/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileAC;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.modelloader.ModelLoader;
import org.eclipse.set.feature.projectdata.utils.ServiceProvider;
import org.eclipse.set.feature.validation.utils.ValidationOutcome;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractImportControl {
    protected IModelSession modelSession;
    protected ServiceProvider serviceProvider;
    private boolean imported;
    protected ModelLoader.ModelContents contentsToImport;

    protected AbstractImportControl(ServiceProvider serviceProvider, IModelSession modelSession) {
        this.modelSession = modelSession;
        this.serviceProvider = serviceProvider;
        this.imported = false;
    }

    public abstract boolean isValid();

    public abstract void resetControl();

    public abstract boolean isEnabled();

    public abstract void doImport(Shell var1);

    public abstract void createControl(Composite var1, Shell var2, ToolboxFileRole var3);

    protected Boolean validatePath(Path path, Consumer<ModelLoader.ModelContents> storeModel, Shell shell, ToolboxFileRole role) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ToolboxFileAC toolboxFile = this.serviceProvider.fileService.loadAC(path, role);){
                toolboxFile.get().setTemporaryDirectory(this.modelSession.getTempDir());
                return this.validatePath(toolboxFile.get(), storeModel, shell);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Boolean validatePath(ToolboxFile toolboxFile, Consumer<ModelLoader.ModelContents> storeModel, Shell shell) {
        ArrayList validationResults = new ArrayList();
        ModelLoader.ModelContents model = this.serviceProvider.modelLoader.loadModelSync(toolboxFile, validationResults::add, shell);
        ValidationResult.FileValidateState fileValidateState = ValidationOutcome.getFileValidateState(validationResults);
        boolean isFileValid = false;
        switch (fileValidateState) {
            case VALID: {
                isFileValid = true;
                break;
            }
            case INCOMPLETE: {
                this.serviceProvider.dialogService.openInformation(shell, this.serviceProvider.messages.PlanProImportPart_incompletePlanProFile, String.format(this.serviceProvider.messages.PlanProImportPart_incompletePlanProFileMessage, toolboxFile.getPath()));
                isFileValid = true;
                break;
            }
            case INVALID: {
                isFileValid = this.serviceProvider.dialogService.loadInvalidModel(shell, toolboxFile.getPath().toString());
                break;
            }
            default: {
                isFileValid = false;
            }
        }
        if (isFileValid) {
            storeModel.accept(model);
        }
        return isFileValid;
    }

    protected abstract ModifyListener selectedFileHandle();

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    public boolean isImported() {
        return this.imported;
    }
}

