/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.ppimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.feature.projectdata.Messages;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.utils.widgets.ComboValues;

public class SubworkComboSelection
extends AbstractEnumerator {
    public static String NOT_SELECTED_SUBWORK = "NOT_SELECTED";
    public static String NOT_SET_SUBWORK = "NOT_SET";

    protected SubworkComboSelection(int value, String name, String literal) {
        super(value, name, literal);
    }

    public static ComboValues<SubworkComboSelection> getComboValues(PlanPro_Schnittstelle schnittstelle, PlanProFileNature fileNature, Messages messages) {
        return new SubworkComboValues(schnittstelle, fileNature, messages);
    }

    public static ComboValues<SubworkComboSelection> getDefaultValues(Messages messages) {
        return new SubworkComboValues(null, PlanProFileNature.INVALID, messages);
    }

    public static ComboValues<SubworkComboSelection> getComboValues(Messages message, List<SubworkComboSelection> values) {
        return new SubworkComboValues(message, values);
    }

    private static class SubworkComboValues
    implements ComboValues<SubworkComboSelection> {
        private final PlanProFileNature fileNature;
        private final PlanPro_Schnittstelle schnittStelle;
        private final Messages messages;
        private List<SubworkComboSelection> itemValues;

        public SubworkComboValues(PlanPro_Schnittstelle schnittStelle, PlanProFileNature fileNature, Messages messages) {
            this.schnittStelle = schnittStelle;
            this.fileNature = fileNature;
            this.messages = messages;
            this.createItems();
        }

        public SubworkComboValues(Messages messages, List<SubworkComboSelection> values) {
            this.schnittStelle = null;
            this.fileNature = null;
            this.messages = messages;
            this.createItems(values);
        }

        private void createItems() {
            switch (this.fileNature) {
                case INVALID: {
                    this.createItems(List.of(new SubworkComboSelection(0, NOT_SELECTED_SUBWORK, this.messages.PlanProImportPart_Subwork_NotSelected)));
                    break;
                }
                case INFORMATION_STATE: {
                    this.createItems(List.of(new SubworkComboSelection(0, NOT_SET_SUBWORK, this.messages.PlanproImportPart_Subwork_Notset)));
                    break;
                }
                case PLANNING: {
                    ArrayList<SubworkComboSelection> items = new ArrayList<SubworkComboSelection>();
                    items.add(new SubworkComboSelection(0, NOT_SELECTED_SUBWORK, this.messages.PlanProImportPart_Subwork_NotSelected));
                    items.addAll(this.getSubworks());
                    this.createItems(items);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.fileNature.toString());
                }
            }
        }

        private void createItems(List<SubworkComboSelection> items) {
            this.itemValues = new LinkedList<SubworkComboSelection>();
            items.forEach(this.itemValues::add);
        }

        private List<SubworkComboSelection> getSubworks() {
            try {
                EList ausgabeFachdaten = this.schnittStelle.getLSTPlanung().getFachdaten().getAusgabeFachdaten();
                return ausgabeFachdaten.stream().map(arg_0 -> this.lambda$1((List)ausgabeFachdaten, arg_0)).toList();
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }

        public int getDefaultIndex() {
            return 0;
        }

        public String getDefaultValue() {
            return this.getValue(this.getDefaultIndex()).getLiteral();
        }

        public int getIndex(SubworkComboSelection value) {
            return value.getValue();
        }

        public int getIndex(String stringValue) {
            return this.itemValues.stream().map(AbstractEnumerator::getLiteral).toList().indexOf(stringValue);
        }

        public String[] getComboValues() {
            return (String[])this.itemValues.stream().map(AbstractEnumerator::getLiteral).toArray(String[]::new);
        }

        public String[] getValuesWithoutDefault() {
            return (String[])this.itemValues.stream().filter(item -> this.getIndex((SubworkComboSelection)((Object)item)) != this.getDefaultIndex()).map(AbstractEnumerator::getLiteral).toArray(String[]::new);
        }

        public SubworkComboSelection getValue(int selectionIndex) {
            Optional<SubworkComboSelection> first = this.itemValues.stream().filter(e -> e.getValue() == selectionIndex).findFirst();
            if (first.isEmpty()) {
                return null;
            }
            return first.get();
        }

        public SubworkComboSelection getValue(String name) {
            Optional<SubworkComboSelection> first = this.itemValues.stream().filter(e -> e.getLiteral().equals(name)).findFirst();
            if (first.isEmpty()) {
                return null;
            }
            return first.get();
        }

        public int size() {
            return this.itemValues.size();
        }

        public String getMaxLengthItem() {
            ArrayList<String> items = new ArrayList<String>();
            items.addAll(List.of(this.messages.PlanProImportPart_Subwork_All, this.messages.PlanProImportPart_Subwork_NotSelected, this.messages.PlanproImportPart_Subwork_Notset));
            StreamSupport.stream(Arrays.asList(ENUMUntergewerkArt.values()).spliterator(), false).forEach(type -> {
                boolean bl = items.add(type.getLiteral());
            });
            return items.stream().reduce((a, b) -> a.length() > b.length() ? a : b).orElse(this.getDefaultValue());
        }

        private /* synthetic */ SubworkComboSelection lambda$1(List list, Ausgabe_Fachdaten fachdaten) {
            try {
                ENUMUntergewerkArt subwork = fachdaten.getUntergewerkArt().getWert();
                return new SubworkComboSelection(list.indexOf(fachdaten) + 1, subwork.getName(), subwork.getLiteral());
            }
            catch (NullPointerException e) {
                return new SubworkComboSelection(list.indexOf(fachdaten) + 1, NOT_SET_SUBWORK, this.messages.PlanproImportPart_Subwork_Notset);
            }
        }
    }
}

