/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.collection;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class MapExtensions {
    public static <T, U> void add(Map<T, List<U>> map, T key, U value) {
        List<U> values = map.get(key);
        if (values != null) {
            values.add(value);
            return;
        }
        map.put(key, CollectionLiterals.newArrayList((Object[])new Object[]{value}));
    }

    public static <T, U> void add(Map<T, List<U>> map, T key, List<U> values) {
        List<U> value = map.get(key);
        if (value != null) {
            value.addAll(values);
            return;
        }
        map.put(key, values);
    }

    public static <T, U> U getValue(Map<T, U> map, T key, Supplier<U> getFunction) {
        U value = map.get(key);
        if (value == null) {
            return getFunction.get();
        }
        return value;
    }

    public static <T, U> Map<T, U> clone(Map<T, U> map) {
        HashMap result = CollectionLiterals.newHashMap();
        result.putAll(map);
        return result;
    }

    public static <T, U> Map<T, U> cloneLinkedHashMap(Map<T, U> map) {
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap();
        result.putAll(map);
        return result;
    }
}

