/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Widget;

public class WidgetRemoteAdapter
implements RemoteAdapter,
SerializableCompatibility {
    private static final Runnable[] EMPTY = new Runnable[0];
    private static final int DATA = 1;
    private static final int LISTENERS = 2;
    private static final int VARIANT = 3;
    private final String id;
    private Widget parent;
    private boolean initialized;
    private transient int preserved;
    private transient Map<String, Object> preservedValues;
    private transient long preservedListeners;
    private transient Runnable[] renderRunnables;
    private transient Object[] data;
    private transient String variant;

    public WidgetRemoteAdapter(String id) {
        this.id = id;
        this.initialize();
    }

    void initialize() {
        this.preservedValues = new HashMap<String, Object>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    @Override
    public Widget getParent() {
        return this.parent;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void preserve(String propertyName, Object value) {
        this.preservedValues.put(propertyName, value);
    }

    @Override
    public Object getPreserved(String propertyName) {
        return this.preservedValues.get(propertyName);
    }

    public void preserveListeners(long eventList) {
        this.markPreserved(2);
        this.preservedListeners = eventList;
    }

    public boolean hasPreservedListeners() {
        return this.hasPreserved(2);
    }

    public long getPreservedListeners() {
        return this.preservedListeners;
    }

    public void preserveData(Object[] data) {
        this.markPreserved(1);
        this.data = data;
    }

    public boolean hasPreservedData() {
        return this.hasPreserved(1);
    }

    public Object[] getPreservedData() {
        return this.data;
    }

    public void preserveVariant(String variant) {
        this.markPreserved(3);
        this.variant = variant;
    }

    public boolean hasPreservedVariant() {
        return this.hasPreserved(3);
    }

    public String getPreservedVariant() {
        return this.variant;
    }

    public void clearPreserved() {
        this.preserved = 0;
        this.preservedValues.clear();
        this.preservedListeners = 0L;
        this.data = null;
        this.variant = null;
    }

    protected void markPreserved(int index) {
        this.preserved |= 1 << index;
    }

    protected boolean hasPreserved(int index) {
        return (this.preserved & 1 << index) != 0;
    }

    protected RemoteObject getRemoteObject() {
        return RemoteObjectFactory.getRemoteObject(this.getId());
    }

    public void addRenderRunnable(Runnable renderRunnable) {
        if (this.renderRunnables == null) {
            this.renderRunnables = new Runnable[]{renderRunnable};
        } else {
            Runnable[] newRunnables = new Runnable[this.renderRunnables.length + 1];
            System.arraycopy(this.renderRunnables, 0, newRunnables, 0, this.renderRunnables.length);
            newRunnables[newRunnables.length - 1] = renderRunnable;
            this.renderRunnables = newRunnables;
        }
    }

    public Runnable[] getRenderRunnables() {
        return this.renderRunnables == null ? EMPTY : this.renderRunnables;
    }

    public void clearRenderRunnables() {
        this.renderRunnables = null;
    }

    @Override
    public void markDisposed(Widget widget) {
        if (this.initialized) {
            DisposedWidgets.add(widget);
        }
    }

    private Object readResolve() {
        this.initialize();
        return this;
    }
}

