/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.ui.internal.branding.AbstractBranding;
import org.eclipse.rap.ui.internal.branding.Header;

public final class BrandingUtil {
    public static final String ENTRY_POINT_BRANDING = "org.eclipse.rap.ui.branding";

    public static String getCurrentBrandingId() {
        EntryPointManager entryPointManager = ContextProvider.getApplicationContext().getEntryPointManager();
        HttpServletRequest request = ContextProvider.getRequest();
        EntryPointRegistration registration = entryPointManager.getEntryPointRegistration(request);
        Map properties = registration.getProperties();
        return (String)properties.get(ENTRY_POINT_BRANDING);
    }

    public static String headerMarkup(AbstractBranding branding) {
        StringBuilder buffer = new StringBuilder();
        BrandingUtil.appendHeaderMarkup(buffer, branding);
        return buffer.toString();
    }

    private static void appendHeaderMarkup(StringBuilder buffer, AbstractBranding branding) {
        Header[] headers = branding.getHeaders();
        if (headers != null) {
            buffer.append(BrandingUtil.createMarkupForHeaders(headers));
        }
    }

    private static String createMarkupForHeaders(Header ... headers) {
        StringBuilder buffer = new StringBuilder();
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            BrandingUtil.appendHeaderMarkup(buffer, header);
            ++n2;
        }
        return buffer.toString();
    }

    private static String appendHeaderMarkup(StringBuilder buffer, Header header) {
        buffer.append("<");
        buffer.append(header.getTagName());
        buffer.append(" ");
        String[] names = header.getNames();
        String[] values = header.getValues();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = values[i];
            if (name != null && value != null) {
                buffer.append(name);
                buffer.append("=\"");
                buffer.append(value);
                buffer.append("\" ");
            }
            ++i;
        }
        buffer.append("/>\n");
        return buffer.toString();
    }

    private BrandingUtil() {
    }
}

