/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.providers;

import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;

public class ObjectsTreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object input) {
        if (input instanceof Collection) {
            Collection inputCollection = (Collection)input;
            return inputCollection.toArray();
        }
        if (input instanceof Object[]) {
            return (Object[])input;
        }
        if (input instanceof ObjectInfo) {
            return this.getChildren(input);
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ObjectInfo) {
            ObjectInfo info = (ObjectInfo)element;
            return info.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ObjectInfo info;
        IObjectPresentation presentation;
        if (element instanceof ObjectInfo && (presentation = (info = (ObjectInfo)element).getPresentation()) != null) {
            return (Boolean)ExecutionUtils.runObjectLog(() -> presentation.isVisible() && !presentation.getChildrenTree().isEmpty(), (Object)false);
        }
        return false;
    }

    public Object[] getChildren(Object element) {
        ObjectInfo info;
        IObjectPresentation presentation;
        if (element instanceof ObjectInfo && (presentation = (info = (ObjectInfo)element).getPresentation()) != null) {
            return (Object[])ExecutionUtils.runObjectLog(() -> presentation.getChildrenTree().toArray(), (Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

