/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.cdo;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.cdo.impl.JavaPackageImpl;
import org.eclipse.modisco.java.cdo.meta.JavaFactory;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.java.discoverer.cdo.Activator;
import org.eclipse.modisco.java.discoverer.internal.io.java.JavaReader;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;

public class JavaDiscovererCDO
extends DiscoverJavaModelFromJavaProject {
    private final String cacheType = "LRU_CACHE";
    private int port = 2036;
    public static final int DEFAULT_LRU_CAPACITY = 1000;
    public static final int DEFAULT_PORT_VALUE = 2036;
    public static final String LRU_CACHE = "LRU_CACHE";
    public static final String DEFAULT_CACHE = "DEFAULT_CACHE";
    public static final String MEM_CACHE = "MEM_CACHE";
    public static final String TWO_LEVEL_CACHE = "TWO_LEVEL_CACHE";
    public static final String CDO_CACHE_TYPE = "CDO_CACHE_TYPE";
    public static final String CURRENT_LRU_CAPACITY = "CURRENT_LRU_CAPACITY";
    public static final String REVISED_LRU_CAPACITY = "REVISED_LRU_CAPACITY";
    public static final String CDO_VERSION = "CDO_VERSION";
    public static final String CDO_SERVER_DESCRIPTION = "CDO_SERVER_DESCRIPTION";
    public static final int LRU_CAPACITY_CURRENT = 100000;
    public static final int LRU_CAPACITY_REVISED = 100;
    private static Map<CDOView, ITCPConnector> connectors = new HashMap<CDOView, ITCPConnector>();

    protected void endAnalyzeJavaProject(Model model) {
        JavaDiscovererCDO.close(model.eResource(), true);
    }

    public static void close(Resource resource, boolean commit) {
        if (resource instanceof CDOResource) {
            CDOResource cdoRessource = (CDOResource)resource;
            CDOView cdoView = cdoRessource.cdoView();
            if (commit && cdoView instanceof CDOTransaction) {
                CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
                try {
                    cdoTransaction.commit();
                }
                catch (CommitException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            org.eclipse.emf.cdo.session.CDOSession cdoSession = cdoView.getSession();
            ITCPConnector connector = connectors.get(cdoView);
            cdoView.close();
            if (cdoSession != null) {
                cdoSession.close();
            }
            if (connector != null) {
                connector.close();
            }
            connectors.remove(cdoView);
        }
    }

    protected Resource createTargetModel() {
        String resourceName2 = "" + System.currentTimeMillis();
        Status status = new Status(1, "org.eclipse.modisco.java.discoverer.cdo", "Resource name=" + resourceName2);
        Activator.getDefault().getLog().log((IStatus)status);
        EPackage ePackage = this.getEFactory().getEPackage();
        if (ePackage == null) {
            throw new RuntimeException("ePackage is null. this.getEFactory()=" + this.getEFactory());
        }
        CDOResource result = JavaDiscovererCDO.getOrCreateCDOResource(resourceName2, ePackage, LRU_CACHE, this.port);
        JavaDiscovererCDO.dbInit(result);
        this.setTargetModel((Resource)result);
        return result;
    }

    public static CDOResource getOrCreateCDOResource(String resourceName, EPackage ePackage, String cacheType, int port) {
        CDOSession session;
        CDOResource resource = null;
        OMPlatform.INSTANCE.setDebugging(true);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        TCPUtil.prepareContainer((IManagedContainer)container);
        Net4jUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        ITCPConnector connector = TCPUtil.getConnector((IManagedContainer)container, (String)("localhost:" + port));
        CDOSessionConfiguration configuration = CDONet4jUtil.createSessionConfiguration();
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName("repo1");
        try {
            session = configuration.openSession();
        }
        catch (ChannelException e) {
            if (e.getCause() instanceof TimeoutRuntimeException) {
                MoDiscoLogger.logError((String)"If you are using the JavaDiscovererCDO in a unit test, the CDO may be not already started. You should increase the org.eclipse.modisco.java.discoverer.tests.cdo.server.AbstractCDOServer.SLEEP_TIME_AFTER_LAUNCHE constant", (Plugin)Activator.getDefault());
            }
            throw e;
        }
        session.getPackageRegistry().putEPackage(ePackage);
        CDOTransaction transaction = session.openTransaction();
        connectors.put((CDOView)transaction, connector);
        String resourcePath = "/" + resourceName;
        Status status = new Status(1, "org.eclipse.modisco.java.discoverer.cdo", resourcePath);
        Activator.getDefault().getLog().log((IStatus)status);
        resource = transaction.getOrCreateResource(resourcePath);
        return resource;
    }

    public org.eclipse.modisco.java.emf.JavaFactory getEFactory() {
        JavaPackageImpl.init();
        return JavaFactory.eINSTANCE;
    }

    private static void dbInit(CDOResource resource) {
        CDOView cdoView = resource.cdoView();
        if (cdoView instanceof CDOTransaction) {
            CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
            try {
                cdoTransaction.commit();
            }
            catch (CommitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected JavaReader getJavaReader(Map<String, Object> elementOptions) {
        JavaReader javaReader = new JavaReader(this.getEFactory(), null, null){

            protected void reset() {
                CDOObject cdoObject;
                CDOView cdoView;
                this.getGlobalBindings().resolveBindings(this.getResultModel());
                if (this.getResultModel() instanceof CDOObject && (cdoView = (cdoObject = (CDOObject)this.getResultModel()).cdoView()) instanceof CDOTransaction) {
                    CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
                    try {
                        cdoTransaction.commit();
                    }
                    catch (CommitException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setGlobalBindings(this.getBindingManager());
            }
        };
        javaReader.setIncremental(true);
        return javaReader;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

