/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.DummyDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public class ExecEnv {
    private Set permissions = new HashSet();
    private Stack frames = new Stack();
    private Map models = new HashMap();
    protected Map globalVariables = new HashMap();
    private Debugger debugger;

    public ExecEnv(Debugger debugger) {
        this.debugger = debugger == null ? new DummyDebugger() : debugger;
    }

    public boolean empty() {
        return this.frames.empty();
    }

    public void push(StackFrame frame) {
        this.frames.push(frame);
    }

    public StackFrame peek() {
        return (StackFrame)this.frames.peek();
    }

    public StackFrame pop() {
        return (StackFrame)this.frames.pop();
    }

    public void addModel(ASMModel model) {
        this.models.put(model.getName(), model);
    }

    public void addModel(String name, ASMModel model) {
        this.models.put(name, model);
    }

    public ASMModel getModel(String name) {
        return (ASMModel)this.models.get(name);
    }

    public Map getModels() {
        return this.models;
    }

    public void printStackTrace() {
        Iterator i = this.frames.iterator();
        while (i.hasNext()) {
            StringTokenizer lines = new StringTokenizer(i.next().toString(), "\n");
            while (lines.hasMoreTokens()) {
                ATLLogger.severe((String)lines.nextToken());
            }
        }
    }

    public ASMOclAny getVariable(String name) {
        return (ASMOclAny)this.globalVariables.get(name);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public Stack getStack() {
        return this.frames;
    }

    public boolean checkPermission(String permission) {
        return this.permissions.contains(permission);
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }
}

