/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.GpgSignHandler;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.RawParseUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_recordChangesToRepository")
class Commit
extends TextBuiltin {
    @Option(name="--author", metaVar="metaVar_author", usage="usage_CommitAuthor")
    private String author;
    @Option(name="--message", aliases={"-m"}, metaVar="metaVar_message", usage="usage_CommitMessage", required=true)
    private String message;
    @Option(name="--only", aliases={"-o"}, usage="usage_CommitOnly")
    private boolean only;
    @Option(name="--all", aliases={"-a"}, usage="usage_CommitAll")
    private boolean all;
    @Option(name="--amend", usage="usage_CommitAmend")
    private boolean amend;
    @Option(name="--gpg-sign", aliases={"-S"}, forbids={"--no-gpg-sign"}, handler=GpgSignHandler.class)
    private String gpgSigningKey;
    @Option(name="--no-gpg-sign", forbids={"--gpg-sign"})
    private boolean noGpgSign;
    @Argument(metaVar="metaVar_commitPaths", usage="usage_CommitPaths")
    private List<String> paths = new ArrayList<String>();

    Commit() {
    }

    @Override
    protected void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.db);){
                String branchName;
                RevCommit commit;
                CommitCommand commitCmd = git.commit();
                if (this.author != null) {
                    commitCmd.setAuthor(RawParseUtils.parsePersonIdent((String)this.author));
                }
                if (this.message != null) {
                    commitCmd.setMessage(this.message);
                }
                if (this.noGpgSign) {
                    commitCmd.setSign(Boolean.FALSE);
                } else if (this.gpgSigningKey != null) {
                    commitCmd.setSign(Boolean.TRUE);
                    if (!this.gpgSigningKey.equals("default")) {
                        commitCmd.setSigningKey(this.gpgSigningKey);
                    }
                }
                if (this.only && this.paths.isEmpty()) {
                    throw Commit.die(CLIText.get().pathsRequired);
                }
                if (this.only && this.all) {
                    throw Commit.die(CLIText.get().onlyOneCommitOptionAllowed);
                }
                if (!this.paths.isEmpty()) {
                    for (String p : this.paths) {
                        commitCmd.setOnly(p);
                    }
                }
                commitCmd.setAmend(this.amend);
                commitCmd.setAll(this.all);
                Ref head = this.db.exactRef("HEAD");
                if (head == null) {
                    throw Commit.die(CLIText.get().onBranchToBeBorn);
                }
                try {
                    commit = commitCmd.call();
                }
                catch (GitAPIException | JGitInternalException e) {
                    throw Commit.die(e.getMessage(), e);
                }
                if (!head.isSymbolic()) {
                    branchName = CLIText.get().branchDetachedHEAD;
                } else {
                    branchName = head.getTarget().getName();
                    if (branchName.startsWith("refs/heads/")) {
                        branchName = branchName.substring("refs/heads/".length());
                    }
                }
                this.outw.println("[" + branchName + " " + commit.name() + "] " + commit.getShortMessage());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw Commit.die(e.getMessage(), (Throwable)e);
        }
    }
}

