/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.math.BigDecimal;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractNumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMBigDecimalBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMBigDecimalBeanTypeProxy
extends REMAbstractNumberBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;
    private static final BigDecimal zeroValue = new BigDecimal(0.0);

    REMBigDecimalBeanTypeProxy(REMProxyFactoryRegistry aRegistry, IBeanTypeProxy numberType) {
        super(aRegistry, new Integer(18), BigDecimal.class.getName(), numberType);
        this.zeroProxy = new REMBigDecimalBeanProxy(aRegistry, zeroValue);
    }

    INumberBeanProxy createBigDecimalBeanProxy(BigDecimal aBigDecimal) {
        return !zeroValue.equals(aBigDecimal) ? new REMBigDecimalBeanProxy(this.fRegistry, aBigDecimal) : this.zeroProxy;
    }

    @Override
    protected INumberBeanProxy createNumberBeanProxy(Number aNumber) {
        return this.createBigDecimalBeanProxy((BigDecimal)aNumber);
    }

    @Override
    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    @Override
    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createBigDecimalBeanProxy((BigDecimal)value.anObject);
    }
}

