/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer;

import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.io.IORuntimeException;

public abstract class CDOTransferElement {
    public static final CDOTransferElement[] NO_CHILDREN = new CDOTransferElement[0];
    private final CDOTransferSystem system;

    protected CDOTransferElement(CDOTransferSystem system) {
        this.system = system;
    }

    public final CDOTransferSystem getSystem() {
        return this.system;
    }

    public abstract Object getNativeObject();

    public abstract boolean isDirectory();

    public abstract IPath getPath();

    public final String getName() {
        return this.getPath().lastSegment();
    }

    public final URI getURI() {
        IPath path = this.getPath();
        return this.system.getURI(path);
    }

    public final boolean isRoot() {
        return this.getParent() == null;
    }

    public final CDOTransferElement getParent() {
        IPath path = this.getPath();
        if (path.isRoot()) {
            return null;
        }
        return this.system.getElement(path.removeLastSegments(1));
    }

    public final CDOTransferElement[] getChildren() {
        if (this.isDirectory()) {
            return this.doGetChildren();
        }
        return NO_CHILDREN;
    }

    public final CDOTransferElement getChild(IPath path) {
        IPath childPath = this.getPath().append(path.makeRelative());
        return this.system.getElement(childPath);
    }

    public final CDOTransferElement getChild(String path) {
        return this.getChild((IPath)new Path(path));
    }

    public final InputStream openInputStream() {
        this.checkNotDirectory();
        return this.doOpenInputStream();
    }

    public int hashCode() {
        String path = this.getPath().toString();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.system == null ? 0 : this.system.hashCode());
        result = 31 * result + (path == null ? 0 : path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CDOTransferElement)) {
            return false;
        }
        CDOTransferElement other = (CDOTransferElement)obj;
        if (this.system != other.system) {
            return false;
        }
        String path = this.getPath().toString();
        String otherPath = other.getPath().toString();
        return !(path == null ? otherPath != null : !path.equals(otherPath));
    }

    public String toString() {
        return this.getPath().toString();
    }

    protected abstract CDOTransferElement[] doGetChildren();

    protected abstract InputStream doOpenInputStream();

    private void checkNotDirectory() {
        if (this.isDirectory()) {
            throw new IORuntimeException("Not supported for directories");
        }
    }
}

