/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentModifier;
import org.eclipse.emf.cdo.explorer.ui.checkouts.ResourceGroup;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class ResourceGroupModifier
implements CDOCheckoutContentModifier {
    private static final Map<CDOResourceNode, ResourceGroup> RESOURCE_GROUPS = new WeakHashMap<CDOResourceNode, ResourceGroup>();
    private final String suffix;

    public ResourceGroupModifier(String extension) {
        this.suffix = "." + extension;
    }

    public final String getExtension() {
        return this.suffix.substring(1);
    }

    @Override
    public Object[] modifyChildren(Object parent, Object[] children) {
        HashMap<String, ResourceGroup> resourceGroups = null;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            CDOResourceNode resourceNode;
            String name;
            Object child = objectArray[n2];
            if (child instanceof CDOResourceNode && (name = (resourceNode = (CDOResourceNode)child).getName()) != null && name.endsWith(this.suffix)) {
                if (resourceGroups == null) {
                    resourceGroups = new HashMap<String, ResourceGroup>();
                }
                String groupName = name.substring(0, name.length() - this.suffix.length());
                ResourceGroup resourceGroup = this.getResourceGroup(resourceNode);
                resourceGroups.put(groupName, resourceGroup);
            }
            ++n2;
        }
        if (resourceGroups != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray2 = children;
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                Object child = objectArray2[n];
                if ((child = this.replacement(resourceGroups, child)) != null) {
                    result.add(child);
                }
                ++n;
            }
            children = result.toArray();
        }
        return children;
    }

    protected ResourceGroup createResourceGroup(CDOResourceNode resourceNode) {
        return new ResourceGroup(resourceNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceGroup getResourceGroup(CDOResourceNode resourceNode) {
        Map<CDOResourceNode, ResourceGroup> map = RESOURCE_GROUPS;
        synchronized (map) {
            ResourceGroup resourceGroup = RESOURCE_GROUPS.get(resourceNode);
            if (resourceGroup == null) {
                resourceGroup = this.createResourceGroup(resourceNode);
                RESOURCE_GROUPS.put(resourceNode, resourceGroup);
            } else {
                resourceGroup.reset();
            }
            return resourceGroup;
        }
    }

    private Object replacement(Map<String, ResourceGroup> elements, Object child) {
        String groupName;
        CDOElement element;
        int lastDot;
        CDOResourceNode resourceNode;
        String name;
        if (child instanceof CDOResourceNode && (name = (resourceNode = (CDOResourceNode)child).getName()) != null && (lastDot = name.lastIndexOf(46)) != -1 && (element = (CDOElement)elements.get(groupName = name.substring(0, lastDot))) != null) {
            element.addChild((Object)resourceNode);
            if (name.endsWith(this.suffix)) {
                return element;
            }
            return null;
        }
        return child;
    }

    public static abstract class Factory
    extends CDOCheckoutContentModifier.Factory {
        public static final String TYPE_PREFIX = "resource.group.";
        private final String extension;

        public Factory(String extension) {
            super(TYPE_PREFIX + extension);
            this.extension = extension;
        }

        @Override
        public final ResourceGroupModifier create(String description) throws ProductCreationException {
            return new ResourceGroupModifier(this.extension);
        }
    }
}

