/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets.styles;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class EEFColor {
    private static final int HEX = 16;
    private static final String KEY_PREFIX = String.valueOf(EEFColor.class.getCanonicalName()) + ".";
    private Color color;

    public EEFColor(String colorCode) {
        if (colorCode.startsWith("#")) {
            this.color = this.hexToColor(colorCode);
        } else if (colorCode.startsWith("rgb")) {
            this.color = this.rgbToColor(colorCode);
        } else {
            String message = MessageFormat.format(Messages.EEFColor_invalidColorCode, colorCode);
            EEFIdeUiPlugin.getPlugin().error(message);
        }
    }

    public EEFColor(Color color) {
        this.color = color;
    }

    public String colorToString() {
        return "rgb(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")";
    }

    private Color hexToColor(String colorCode) {
        RGB rgb = this.hexToRGB(colorCode.substring(1));
        return this.getColor(rgb.red, rgb.green, rgb.blue);
    }

    private Color rgbToColor(String colorCode) {
        Pattern c = Pattern.compile("rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)");
        Matcher m = c.matcher(colorCode);
        if (m.matches()) {
            return this.getColor(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
        }
        return null;
    }

    private Color getColor(int red, int green, int blue) {
        String key = this.getColorKey(red, green, blue);
        if (JFaceResources.getColorRegistry().hasValueFor(key)) {
            return JFaceResources.getColorRegistry().get(key);
        }
        JFaceResources.getColorRegistry().put(key, new RGB(red, green, blue));
        return this.getColor(key);
    }

    private Color getColor(String key) {
        return JFaceResources.getColorRegistry().get(key);
    }

    private String getColorKey(int red, int green, int blue) {
        return String.valueOf(KEY_PREFIX) + "_COLOR_" + red + "_" + green + "_" + blue;
    }

    public Color getColor() {
        return this.color;
    }

    private RGB hexToRGB(String hex) {
        RGB rgb = null;
        if (hex != null && hex.length() == 6) {
            rgb = new RGB(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
        }
        return rgb;
    }
}

