/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.ArchiveFolder;
import org.eclipse.dltk.internal.core.ArchiveFolderInfo;
import org.eclipse.dltk.internal.core.ArchiveProjectFragmentInfo;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelProviderManager;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.dltk.internal.core.util.Util;

public class ArchiveProjectFragment
extends ProjectFragment {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath zipPath;
    protected final IResource zipResource;
    private IArchive archive;

    protected ArchiveProjectFragment(IResource resource, ScriptProject project) {
        super(resource, project);
        this.zipPath = resource.getFullPath();
        this.zipResource = resource;
    }

    protected ArchiveProjectFragment(IPath path, ScriptProject project) {
        super(null, project);
        this.zipPath = path;
        this.zipResource = null;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        ArrayList<IModelElement> vChildren = new ArrayList<IModelElement>();
        boolean SCRIPT = false;
        boolean NON_SCRIPT = true;
        this.archive = null;
        try {
            try {
                this.archive = ModelManager.getModelManager().getArchive(this.getPath(), this);
                HashtableOfArrayToObject packageFragToTypes = new HashtableOfArrayToObject();
                packageFragToTypes.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                Enumeration<? extends IArchiveEntry> e = this.archive.getArchiveEntries();
                while (e.hasMoreElements()) {
                    IArchiveEntry member = e.nextElement();
                    this.initPackageFragToTypes(packageFragToTypes, member.getName(), member.isDirectory());
                }
                int i = 0;
                int length = packageFragToTypes.keyTable.length;
                while (i < length) {
                    Object[] pkgName = (String[])packageFragToTypes.keyTable[i];
                    if (pkgName != null) {
                        ArrayList[] entries = (ArrayList[])packageFragToTypes.get(pkgName);
                        Object path = "";
                        if (pkgName.length >= 1) {
                            path = pkgName[0];
                            int e2 = 1;
                            while (e2 < pkgName.length) {
                                path = (String)path + "/" + (String)pkgName[e2];
                                ++e2;
                            }
                        }
                        Path lpath = new Path((String)path);
                        ArchiveFolder packFrag = (ArchiveFolder)this.getScriptFolder((IPath)lpath);
                        ArchiveFolderInfo fragInfo = new ArchiveFolderInfo();
                        int resLength = entries[1].size();
                        if (resLength == 0) {
                            packFrag.computeForeignResources(CharOperation.NO_STRINGS, fragInfo, this.archive.getName());
                        } else {
                            String[] resNames = new String[resLength];
                            entries[1].toArray(resNames);
                            packFrag.computeForeignResources(resNames, fragInfo, this.archive.getName());
                        }
                        if (lpath.segmentCount() == 0) {
                            ((ArchiveProjectFragmentInfo)info).setForeignResources(fragInfo.foreignResources);
                        }
                        packFrag.computeChildren(fragInfo, entries[0]);
                        newElements.put(packFrag, fragInfo);
                        vChildren.add(packFrag);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (e instanceof ModelException) {
                    throw (ModelException)e;
                }
                throw new ModelException(e);
            }
        }
        finally {
            ModelManager.getModelManager().closeArchive(this.archive);
        }
        ArrayList<IModelElement> childrenSet = vChildren;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        IModelProvider[] providers = ModelProviderManager.getProviders(toolkit.getNatureId());
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                providers[i].provideModelChanges(this, childrenSet);
                ++i;
            }
        }
        info.setChildren(childrenSet.toArray(new IModelElement[childrenSet.size()]));
        return true;
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        return new ArchiveFolder(this, path);
    }

    public String getZipName() {
        IEnvironment environment = EnvironmentManager.getEnvironment(this.getScriptProject());
        return environment.convertPathToString(this.zipPath);
    }

    private void initPackageFragToTypes(HashtableOfArrayToObject packageFragToTypes, String entryName, boolean isDirectory) {
        int length;
        int lastSeparator = isDirectory ? entryName.length() - 1 : entryName.lastIndexOf(47);
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        int existingLength = length = pkgName.length;
        while (existingLength >= 0) {
            existing = (String[])packageFragToTypes.getKey(pkgName, existingLength);
            if (existing != null) break;
            --existingLength;
        }
        ModelManager manager = ModelManager.getModelManager();
        int i = existingLength;
        while (i < length) {
            if (!Util.isValidFolderNameForPackage((String)pkgName[i])) {
                if (!isDirectory) {
                    ArrayList[] children = (ArrayList[])packageFragToTypes.get(existing);
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(entryName);
                }
                return;
            }
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = manager.intern((String)pkgName[i]);
            packageFragToTypes.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            ++i;
        }
        if (isDirectory) {
            return;
        }
        ArrayList[] children = (ArrayList[])packageFragToTypes.get(pkgName);
        if (Util.isValidSourceModuleName(this.getScriptProject(), entryName)) {
            if (children[0] == EMPTY_LIST) {
                children[0] = new ArrayList();
            }
            String fileName = entryName.substring(lastSeparator + 1);
            children[0].add(fileName);
        } else {
            if (children[1] == EMPTY_LIST) {
                children[1] = new ArrayList();
            }
            children[1].add(entryName);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected Object createElementInfo() {
        return new ArchiveProjectFragmentInfo();
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.getResource() == null;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return this.zipPath.hashCode();
    }

    @Override
    public IPath getPath() {
        return this.zipPath;
    }

    @Override
    public IResource getResource() {
        if (this.resource == null) {
            this.resource = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.zipPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    @Override
    protected boolean resourceExists() {
        if (this.isExternal()) {
            return Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    @Override
    protected void toStringAncestors(StringBuilder buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArchiveProjectFragment) {
            ArchiveProjectFragment other = (ArchiveProjectFragment)o;
            return this.zipPath.equals((Object)other.zipPath);
        }
        return false;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    @Override
    public String getElementName() {
        if (this.isExternal()) {
            IEnvironment env = EnvironmentManager.getEnvironment(this);
            if (env == null) {
                env = EnvironmentPathUtils.getPathEnvironment(this.zipPath);
            }
            String pathString = EnvironmentPathUtils.getLocalPathString(this.zipPath);
            if (env != null && pathString != null) {
                return pathString.replace(env.getSeparatorChar(), '>');
            }
        }
        return this.zipPath.lastSegment();
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }
}

