/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.api;

import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IGenerator;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.framework.PlatformConfig;

public class ChartEngine {
    private PluginSettings ps = null;
    private static ChartEngine ce = null;

    private ChartEngine(PluginSettings ps) {
        this.ps = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChartEngine instance(PlatformConfig config) {
        if (ce != null) return ce;
        Class<ChartEngine> clazz = ChartEngine.class;
        synchronized (ChartEngine.class) {
            if (ce != null) return ce;
            PluginSettings ps = PluginSettings.instance(config);
            ce = new ChartEngine(ps);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ce;
        }
    }

    public static ChartEngine instance() {
        return ChartEngine.instance(null);
    }

    @Deprecated
    public Serializer getSerializer() {
        return SerializerImpl.instance();
    }

    public IGenerator getGenerator() {
        return Generator.instance();
    }

    public IDeviceRenderer getRenderer(String deviceID) throws ChartException {
        return this.ps.getDevice(deviceID);
    }

    public final IDataSetProcessor getDataSetProcessor(Class cSeries) throws ChartException {
        return this.ps.getDataSetProcessor(cSeries);
    }
}

