"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.MdHoverProvider = void 0;
const documentLink_1 = require("../types/documentLink");
const range_1 = require("../types/range");
const mdBuilder = require("../util/mdBuilder");
const media_1 = require("../util/media");
class MdHoverProvider {
    #linkProvider;
    constructor(linkProvider) {
        this.#linkProvider = linkProvider;
    }
    async provideHover(document, pos, token) {
        const links = await this.#linkProvider.getLinks(document);
        if (token.isCancellationRequested) {
            return;
        }
        const link = links.links.find(link => (0, range_1.rangeContains)(link.source.hrefRange, pos));
        if (!link || link.href.kind === documentLink_1.HrefKind.Reference) {
            return;
        }
        const contents = this.#getHoverContents(link);
        return contents && {
            contents,
            range: link.source.hrefRange
        };
    }
    #getHoverContents(link) {
        if (link.href.kind === documentLink_1.HrefKind.Reference) {
            return undefined;
        }
        const uri = link.href.kind === documentLink_1.HrefKind.External ? link.href.uri : link.href.path;
        const mediaType = (0, media_1.getMediaPreviewType)(uri);
        const maxWidth = 300;
        switch (mediaType) {
            case media_1.MediaType.Image: {
                return {
                    kind: 'markdown',
                    value: mdBuilder.imageLink(uri, '', maxWidth),
                };
            }
            case media_1.MediaType.Video: {
                return {
                    kind: 'markdown',
                    value: mdBuilder.video(uri, maxWidth),
                };
            }
        }
        return undefined;
    }
}
exports.MdHoverProvider = MdHoverProvider;
//# sourceMappingURL=hover.js.map