/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.color.AbstractColorUpdater;
import org.eclipse.sirius.properties.core.api.IDescriptionConverter;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.Messages;
import org.eclipse.sirius.properties.core.internal.SiriusPropertiesCorePlugin;
import org.eclipse.sirius.properties.core.internal.converter.SiriusInitialOperationAdapter;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;

public abstract class AbstractDescriptionConverter
implements IDescriptionConverter {
    protected <T> T convertEObject(EObject eObject, Map<String, Object> parameters, TransformationCache cache, Class<T> expectedClass) {
        if (eObject != null) {
            Optional<IDescriptionConverter> converterOptional = SiriusPropertiesCorePlugin.getPlugin().getDescriptionConverter(eObject);
            if (converterOptional.isPresent()) {
                EObject eefEObject = converterOptional.get().convert(eObject, parameters, cache);
                if (expectedClass.isAssignableFrom(eefEObject.getClass())) {
                    return expectedClass.cast(eefEObject);
                }
            } else {
                SiriusPropertiesCorePlugin.getPlugin().error(MessageFormat.format(Messages.AbstractDescriptionConverter_noConverterFound, eObject));
            }
        }
        return null;
    }

    protected <T> List<T> convertCollection(Collection<?> eObjects, Map<String, Object> parameters, TransformationCache cache, Class<T> expectedClass) {
        ArrayList<T> convertedEObjects = new ArrayList<T>();
        for (Object eObject : eObjects) {
            T convertedEObject;
            if (!(eObject instanceof EObject) || (convertedEObject = this.convertEObject((EObject)eObject, parameters, cache, expectedClass)) == null) continue;
            convertedEObjects.add(convertedEObject);
        }
        return convertedEObjects;
    }

    protected String getExpressionForOperation(InitialOperation initialOperation) {
        if (initialOperation != null) {
            String expression = "";
            Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)initialOperation, SiriusInitialOperationAdapter.class);
            expression = adapter instanceof SiriusInitialOperationAdapter ? ((SiriusInitialOperationAdapter)adapter).getInitialOperationURI().toString() : EcoreUtil.getURI((EObject)initialOperation).toString();
            expression = expression.replace("'", "\\'");
            return MessageFormat.format("aql:input.executeOperation(self, ''{0}'')", expression);
        }
        return null;
    }

    protected String getColorExpression(ColorDescription colorDescription, Map<String, Object> parameters) {
        SiriusInputDescriptor inputDescriptor;
        AbstractColorUpdater colorUpdater;
        RGBValues rgbValues;
        Object object = parameters.get("input");
        if (object instanceof SiriusInputDescriptor && (rgbValues = (colorUpdater = new AbstractColorUpdater()).getRGBValuesFromColorDescription((inputDescriptor = (SiriusInputDescriptor)object).getSemanticElement(), colorDescription)) != null) {
            return MessageFormat.format("rgb({0},{1},{2})", rgbValues.getRed(), rgbValues.getGreen(), rgbValues.getBlue());
        }
        return null;
    }
}

