/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.util.INamespaceResolver;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class DefaultNamespaceResolver
implements INamespaceResolver {
    private static final String EMPTY = "";
    private IProject project;

    @Override
    public String resolveNamespace(IPath folder) {
        if ((folder = folder.removeFirstSegments(this.firstSegmentsToRemoveForNamespace(folder))).segmentCount() > 0) {
            String defaultNamespace = folder.toString().replace('/', '\\');
            if (defaultNamespace.endsWith("\\")) {
                defaultNamespace = defaultNamespace.substring(0, defaultNamespace.length() - 1);
            }
            return defaultNamespace;
        }
        return EMPTY;
    }

    @Override
    public IPath resolveLocation(IPath path, String namespaceText) {
        String[] segments;
        int removedSegmentNumber = this.firstSegmentsToRemoveForNamespace(path);
        path = path.removeLastSegments(path.segmentCount() - removedSegmentNumber);
        String[] stringArray = segments = namespaceText.split("\\\\");
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            path = path.append(segment);
            ++n2;
        }
        return path;
    }

    @Override
    public void init(IProject project) {
        this.project = project;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    private int firstSegmentsToRemoveForNamespace(IPath sourcePath) {
        block6: {
            if (this.project != null && this.project.exists() && PHPToolkitUtil.isPHPProject(this.project)) break block6;
            return 1;
        }
        try {
            IScriptProject scriptProject = DLTKCore.create((IProject)this.project);
            IProjectFragment[] iProjectFragmentArray = scriptProject.getProjectFragments();
            int n = iProjectFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                int matching = projectFragment.getPath().matchingFirstSegments(sourcePath);
                if (matching > 1) {
                    return matching;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
        }
        return 1;
    }
}

