/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.api.tools.ui.internal.actions.DeltaSession;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeViewerNavigator {
    private final TreeViewer fViewer;

    public TreeViewerNavigator(TreeViewer viewer) {
        this.fViewer = viewer;
    }

    public void navigateNext(boolean forward) {
        TreeItem currentItem = this.getCurrentItem(forward);
        if (currentItem == null) {
            return;
        }
        TreeItem nextItem = null;
        if (forward) {
            nextItem = this.getNextItemForward(currentItem);
            if (nextItem == null) {
                nextItem = this.getFirstItem();
            }
        } else {
            nextItem = this.getNextItemBackward(currentItem);
            if (nextItem == null) {
                nextItem = this.getLastItem();
            }
        }
        if (nextItem != null) {
            this.internalSetSelection(nextItem);
        }
    }

    private TreeItem getFirstItem() {
        TreeItem[] roots = this.fViewer.getTree().getItems();
        if (roots.length == 0) {
            return null;
        }
        TreeItem[] treeItemArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem root = treeItemArray[n2];
            if (this.hasMatches(root)) {
                return root;
            }
            TreeItem firstChild = this.getFirstChildWithMatches(roots[0]);
            if (firstChild != null) {
                return firstChild;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem getLastItem() {
        TreeItem[] roots = this.fViewer.getTree().getItems();
        if (roots.length == 0) {
            return null;
        }
        return this.getLastChildWithMatches(roots[roots.length - 1]);
    }

    private TreeItem getNextItemBackward(TreeItem currentItem) {
        TreeItem previousSibling = this.getNextSibling(currentItem, false);
        if (previousSibling != null) {
            TreeItem lastChild = this.getLastChildWithMatches(previousSibling);
            if (lastChild != null) {
                return lastChild;
            }
            if (this.hasMatches(previousSibling)) {
                return previousSibling;
            }
            return null;
        }
        TreeItem parent = currentItem.getParentItem();
        if (parent != null) {
            if (this.hasMatches(parent)) {
                return parent;
            }
            return this.getNextItemBackward(parent);
        }
        return null;
    }

    private TreeItem getLastChildWithMatches(TreeItem currentItem) {
        TreeItem[] children = this.getChildren(currentItem);
        if (children.length == 0) {
            return null;
        }
        TreeItem recursiveChild = this.getLastChildWithMatches(children[children.length - 1]);
        if (recursiveChild == null) {
            return children[children.length - 1];
        }
        return recursiveChild;
    }

    private TreeItem getNextItemForward(TreeItem currentItem) {
        TreeItem child = this.getFirstChildWithMatches(currentItem);
        if (child != null) {
            return child;
        }
        TreeItem nextSibling = this.getNextSibling(currentItem, true);
        if (nextSibling != null) {
            if (this.hasMatches(nextSibling)) {
                return nextSibling;
            }
            return this.getFirstChildWithMatches(nextSibling);
        }
        TreeItem parent = currentItem.getParentItem();
        while (parent != null) {
            nextSibling = this.getNextSibling(parent, true);
            if (nextSibling != null) {
                if (this.hasMatches(nextSibling)) {
                    return nextSibling;
                }
                return this.getFirstChildWithMatches(nextSibling);
            }
            parent = parent.getParentItem();
        }
        return null;
    }

    private TreeItem getFirstChildWithMatches(TreeItem item) {
        TreeItem[] children = this.getChildren(item);
        if (children.length == 0) {
            return null;
        }
        TreeItem child = children[0];
        if (this.hasMatches(child)) {
            return child;
        }
        return this.getFirstChildWithMatches(child);
    }

    private TreeItem[] getChildren(TreeItem item) {
        this.fViewer.setExpandedState(item.getData(), true);
        return item.getItems();
    }

    private TreeItem getNextSibling(TreeItem currentItem, boolean forward) {
        TreeItem[] siblings = this.getSiblings(currentItem);
        if (siblings.length < 2) {
            return null;
        }
        int index = -1;
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == currentItem) {
                index = i;
                break;
            }
            ++i;
        }
        if (forward && index == siblings.length - 1) {
            return null;
        }
        if (!forward && index == 0) {
            return null;
        }
        return forward ? siblings[index + 1] : siblings[index - 1];
    }

    private TreeItem[] getSiblings(TreeItem currentItem) {
        Tree tree = this.fViewer.getTree();
        TreeItem parentItem = currentItem.getParentItem();
        if (parentItem != null) {
            return parentItem.getItems();
        }
        return tree.getItems();
    }

    private boolean hasMatches(TreeItem item) {
        Object element = item.getData();
        if (element instanceof DeltaSession.TreeNode) {
            DeltaSession.TreeNode node = (DeltaSession.TreeNode)element;
            return node.getData() != null && !node.hasChildren();
        }
        return element != null;
    }

    private TreeItem getCurrentItem(boolean forward) {
        Tree tree = this.fViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            selection = tree.getItems();
        }
        TreeItem nextItem = null;
        if (selection.length > 0) {
            nextItem = forward ? selection[0] : selection[selection.length - 1];
        }
        return nextItem;
    }

    private void internalSetSelection(TreeItem ti) {
        Object data;
        if (ti != null && (data = ti.getData()) != null) {
            StructuredSelection selection = new StructuredSelection(data);
            this.fViewer.setSelection((ISelection)selection, true);
        }
    }
}

