/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.wtp.overlay.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class CompressionUtil {
    private static final int BUFFER = 4096;

    private CompressionUtil() {
    }

    public static void unzip(File archive, File projectFolderFile, IProgressMonitor monitor) throws IOException, FileNotFoundException, InterruptedException {
        CompressionUtil.initialize(projectFolderFile);
        ZipFile zipFile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.CompressionUtil_Extracting_Task, zipFile.size());
        try {
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                File file = new File(projectFolderFile, zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    monitor.subTask(zipEntry.getName());
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    InputStream is = null;
                    FileOutputStream os = null;
                    try {
                        int len;
                        is = zipFile.getInputStream(zipEntry);
                        os = new FileOutputStream(file);
                        byte[] buffer = new byte[4096];
                        while ((len = is.read(buffer)) >= 0) {
                            ((OutputStream)os).write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close((InputStream)is);
                        FileUtils.close(os);
                        throw throwable;
                    }
                    FileUtils.close((InputStream)is);
                    FileUtils.close((OutputStream)os);
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException(NLS.bind((String)Messages.CompressionUtil_Unzipping_Interrupted, (Object)archive.getAbsolutePath(), (Object)projectFolderFile.getAbsolutePath()));
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void initialize(File outputDirectory) throws IOException {
        if (!outputDirectory.mkdirs() && !outputDirectory.exists()) {
            throw new IOException(Messages.CompressionUtil_Unable_To_Create_Output_Dir + String.valueOf(outputDirectory));
        }
        if (outputDirectory.isFile()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.CompressionUtil_Unpacking_Unable, (Object)outputDirectory.getAbsolutePath()));
        }
    }
}

