/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.server.db.evolution.phased.PhasedModelEvolutionSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.StatementBatcher;
import org.eclipse.net4j.util.properties.IPropertiesContainer;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public final class Context
implements CDOTimeProvider,
IPropertiesContainer {
    private final IRegistry<String, Object> properties = new HashMapRegistry.AutoCommit();
    private final PhasedModelEvolutionSupport support;
    private final long timeStamp;
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Map<Model, Object> changeInfos = new HashMap<Model, Object>();
    private final Map<String, EPackage> oldPackages = new HashMap<String, EPackage>();
    private final EMFUtil.TreeMapping<EObject> elementMappings = new EMFUtil.TreeMapping(EObject.class);
    private final Map<EEnum, Map<Integer, Integer>> enumLiteralChanges = new HashMap<EEnum, Map<Integer, Integer>>();
    private final AtomicInteger totalUpdateCount = new AtomicInteger();

    public Context(PhasedModelEvolutionSupport support, Collection<Model> models) {
        this.support = support;
        this.timeStamp = support.getStore().getRepository().getTimeStamp();
        models.forEach(model -> {
            this.models.put(model.getID(), (Model)model);
            EPackage oldPackage = model.getOldPackage();
            EMFUtil.getAllPackages((EPackage)oldPackage, ePackage -> {
                EPackage ePackage2 = this.oldPackages.put(ePackage.getNsURI(), (EPackage)ePackage);
            });
            this.elementMappings.map((EObject)oldPackage, (EObject)model.getNewPackage(), true);
        });
    }

    public PhasedModelEvolutionSupport getSupport() {
        return this.support;
    }

    public IRegistry<String, Object> properties() {
        return this.properties;
    }

    public void log(Object message) {
        this.support.log(message);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Map<String, Model> getModels() {
        return Collections.unmodifiableMap(this.models);
    }

    public Map<Model, Object> getChangeInfos() {
        return Collections.unmodifiableMap(this.changeInfos);
    }

    public void addChangeInfo(Model model, Object changeInfo) {
        this.changeInfos.put(model, Objects.requireNonNull(changeInfo));
        this.support.addedChangeInfo(model, changeInfo);
    }

    public Map<String, EPackage> getOldPackages() {
        return Collections.unmodifiableMap(this.oldPackages);
    }

    public EMFUtil.TreeMapping<EObject> getElementMappings() {
        return this.elementMappings;
    }

    public <T extends EObject> T getNewElement(T oldElement) {
        EObject newElement = (EObject)this.elementMappings.get(oldElement);
        return (T)newElement;
    }

    public Map<Integer, Integer> getEnumLiteralChanges(EEnum oldEnum) {
        return this.enumLiteralChanges.computeIfAbsent(oldEnum, k -> {
            HashMap changes = new HashMap();
            EEnum newEnum = (EEnum)this.elementMappings.get((Object)oldEnum);
            if (newEnum != null) {
                oldEnum.getELiterals().forEach(oldLiteral -> {
                    int newLiteralID;
                    int oldLiteralID;
                    EEnumLiteral newLiteral = (EEnumLiteral)this.elementMappings.get(oldLiteral);
                    if (newLiteral != null && (oldLiteralID = oldLiteral.getValue()) != (newLiteralID = newLiteral.getValue())) {
                        changes.put(oldLiteralID, newLiteralID);
                    }
                });
            }
            return changes;
        });
    }

    public <F extends EStructuralFeature> void handleFeatureIDChanges(EClass oldClass, Function<EClass, Collection<F>> featureProvider, BiConsumer<Integer, Integer> handler) {
        Collection<F> oldFeatures;
        EClass newClass;
        if (handler != null && (newClass = (EClass)this.elementMappings.get((Object)oldClass)) != null && (oldFeatures = featureProvider.apply(oldClass)) != null) {
            oldFeatures.forEach(oldFeature -> {
                int newFeatureID;
                int oldFeatureID;
                EStructuralFeature newFeature = (EStructuralFeature)this.elementMappings.get(oldFeature);
                if (newFeature != null && (oldFeatureID = oldClass.getFeatureID(oldFeature)) != (newFeatureID = newClass.getFeatureID(newFeature))) {
                    handler.accept(oldFeatureID, newFeatureID);
                }
            });
        }
    }

    public StatementBatcher createStatementBatcher(Connection connection) throws SQLException {
        StatementBatcher batcher = new StatementBatcher(connection);
        batcher.addListener(event -> {
            if (event instanceof StatementBatcher.BatchEvent || event instanceof StatementBatcher.ResultEvent) {
                this.log(event);
            } else if (event instanceof StatementBatcher.CloseEvent) {
                this.totalUpdateCount.addAndGet(batcher.getTotalUpdateCount());
            }
        });
        return batcher;
    }

    public int getTotalUpdateCount() {
        return this.totalUpdateCount.get();
    }

    public int incrementTotalUpdateCount() {
        return this.totalUpdateCount.incrementAndGet();
    }

    public int incrementTotalUpdateCount(int delta) {
        return this.totalUpdateCount.addAndGet(delta);
    }

    public static interface Manager {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.db.evolution.contextManagers";

        public PhasedModelEvolutionSupport getSupport();

        public void setSupport(PhasedModelEvolutionSupport var1);

        public Context createContext() throws Exception;

        public Context loadContext() throws Exception;

        public void saveContext(Context var1) throws Exception;
    }

    public static final class Model {
        private final String id;
        private final CDOPackageUnit.Type originalType;
        private final long timeStamp;
        private final EPackage oldPackage;
        private final EPackage newPackage;
        private String oldXMI;
        private String newXMI;

        public Model(String id, CDOPackageUnit.Type originalType, long timeStamp, EPackage oldPackage, EPackage newPackage) {
            this.id = id;
            this.originalType = originalType;
            this.timeStamp = timeStamp;
            this.oldPackage = oldPackage;
            this.newPackage = newPackage;
        }

        public String getID() {
            return this.id;
        }

        public CDOPackageUnit.Type getOriginalType() {
            return this.originalType;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public EPackage getOldPackage() {
            return this.oldPackage;
        }

        public EPackage getNewPackage() {
            return this.newPackage;
        }

        public String getOldXMI() {
            if (this.oldXMI == null) {
                this.oldXMI = EMFUtil.getXMI((EPackage)this.oldPackage);
            }
            return this.oldXMI;
        }

        public String getNewXMI() {
            if (this.newXMI == null && this.newPackage != null) {
                this.newXMI = EMFUtil.getXMI((EPackage)this.newPackage);
            }
            return this.newXMI;
        }

        public boolean isRemoved() {
            return this.newPackage == null;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Model other = (Model)obj;
            return Objects.equals(this.id, other.id);
        }

        public String toString() {
            return "Model[id=" + this.id + ", originalType=" + this.originalType + ", timeStamp=" + this.timeStamp + "]";
        }
    }
}

