/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.win32;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.util.Collections;
import java.util.Map;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.Platform;

public class WindowsRegistryImpl
extends WindowsRegistry {
    private static final boolean DEBUG = Platform.getDebugBoolean((String)"org.eclipse.cdt.core.native/debug/win32/registry");

    public String getLocalMachineValue(String subkey, String name) {
        return this.getValue(WinReg.HKEY_LOCAL_MACHINE, subkey, name);
    }

    public Map<String, Object> getLocalMachineValues(String subkey) {
        return this.getValues(WinReg.HKEY_LOCAL_MACHINE, subkey);
    }

    public String getLocalMachineValueName(String subkey, int index) {
        return this.getValueName(WinReg.HKEY_LOCAL_MACHINE, subkey, index);
    }

    public String getLocalMachineKeyName(String subkey, int index) {
        return this.getKeyName(WinReg.HKEY_LOCAL_MACHINE, subkey, index);
    }

    public String getCurrentUserValue(String subkey, String name) {
        return this.getValue(WinReg.HKEY_CURRENT_USER, subkey, name);
    }

    public Map<String, Object> getCurrentUserValues(String subkey) {
        return this.getValues(WinReg.HKEY_CURRENT_USER, subkey);
    }

    public String getCurrentUserValueName(String subkey, int index) {
        return this.getValueName(WinReg.HKEY_CURRENT_USER, subkey, index);
    }

    public String getCurrentUserKeyName(String subkey, int index) {
        return this.getKeyName(WinReg.HKEY_CURRENT_USER, subkey, index);
    }

    private String getValue(WinReg.HKEY key, String subkey, String name) {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)key, (String)subkey, (String)name);
        }
        catch (Win32Exception e) {
            if (DEBUG) {
                CNativePlugin.log((String)String.format("Unable to get value for %s in %s", name, subkey), (Throwable)e);
            }
            return null;
        }
    }

    private String getKeyName(WinReg.HKEY key, String subkey, int index) {
        String string;
        WinReg.HKEYByReference phkKey = Advapi32Util.registryGetKey((WinReg.HKEY)key, (String)subkey, (int)131097);
        try {
            Advapi32Util.EnumKey enumKey = Advapi32Util.registryRegEnumKey((WinReg.HKEY)phkKey.getValue(), (int)index);
            string = Native.toString((char[])enumKey.lpName);
        }
        catch (Throwable throwable) {
            try {
                Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
                throw throwable;
            }
            catch (Win32Exception e) {
                if (DEBUG) {
                    CNativePlugin.log((String)String.format("Unable to get keyname for %s at index %d", subkey, index), (Throwable)e);
                }
                return null;
            }
        }
        Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
        return string;
    }

    private String getValueName(WinReg.HKEY key, String subkey, int index) {
        String string;
        WinReg.HKEYByReference phkKey = Advapi32Util.registryGetKey((WinReg.HKEY)key, (String)subkey, (int)131097);
        try {
            char[] lpValueName = new char[255];
            IntByReference lpcchValueName = new IntByReference(255);
            int rc = Advapi32.INSTANCE.RegEnumValue(phkKey.getValue(), index, lpValueName, lpcchValueName, null, null, null, null);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            string = Native.toString((char[])lpValueName);
        }
        catch (Throwable throwable) {
            try {
                Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
                throw throwable;
            }
            catch (Win32Exception e) {
                if (DEBUG) {
                    CNativePlugin.log((String)String.format("Unable to get valuename for %s at index %d", subkey, index), (Throwable)e);
                }
                return null;
            }
        }
        Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
        return string;
    }

    private Map<String, Object> getValues(WinReg.HKEY key, String subkey) {
        try {
            return Advapi32Util.registryGetValues((WinReg.HKEY)key, (String)subkey);
        }
        catch (Win32Exception e) {
            if (DEBUG) {
                CNativePlugin.log((String)String.format("Unable to get values for %s", subkey), (Throwable)e);
            }
            return Collections.emptyMap();
        }
    }
}

