/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;

class AssertIterableEquals {
    private AssertIterableEquals() {
    }

    static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual) {
        AssertIterableEquals.assertIterableEquals(expected, actual, (String)null);
    }

    static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, String message) {
        AssertIterableEquals.assertIterableEquals(expected, actual, new ArrayDeque<Integer>(), message);
    }

    static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, Supplier<String> messageSupplier) {
        AssertIterableEquals.assertIterableEquals(expected, actual, new ArrayDeque<Integer>(), messageSupplier);
    }

    private static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, Deque<Integer> indexes, Object messageOrSupplier) {
        AssertIterableEquals.assertIterableEquals(expected, actual, indexes, messageOrSupplier, new LinkedHashMap<Pair, Status>());
    }

    private static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, Deque<Integer> indexes, Object messageOrSupplier, Map<Pair, Status> investigatedElements) {
        if (expected == actual) {
            return;
        }
        AssertIterableEquals.assertIterablesNotNull(expected, actual, indexes, messageOrSupplier);
        Iterator<?> expectedIterator = expected.iterator();
        Iterator<?> actualIterator = actual.iterator();
        int processed = 0;
        while (expectedIterator.hasNext() && actualIterator.hasNext()) {
            Object expectedElement = expectedIterator.next();
            Object actualElement = actualIterator.next();
            indexes.addLast(processed);
            AssertIterableEquals.assertIterableElementsEqual(expectedElement, actualElement, indexes, messageOrSupplier, investigatedElements);
            indexes.removeLast();
            ++processed;
        }
        AssertIterableEquals.assertIteratorsAreEmpty(expectedIterator, actualIterator, processed, indexes, messageOrSupplier);
    }

    private static void assertIterableElementsEqual(Object expected, Object actual, Deque<Integer> indexes, Object messageOrSupplier, Map<Pair, Status> investigatedElements) {
        if (Objects.equals(expected, actual)) {
            return;
        }
        if (expected instanceof Iterable && actual instanceof Iterable) {
            Pair pair = new Pair(expected, actual);
            Status status = investigatedElements.get(pair);
            if (status == Status.CONTAIN_SAME_ELEMENTS) {
                return;
            }
            if (status == Status.UNDER_INVESTIGATION) {
                indexes.removeLast();
                AssertIterableEquals.failIterablesNotEqual(expected, actual, indexes, messageOrSupplier);
            }
            investigatedElements.put(pair, Status.UNDER_INVESTIGATION);
            AssertIterableEquals.assertIterableEquals((Iterable)expected, (Iterable)actual, indexes, messageOrSupplier, investigatedElements);
            investigatedElements.put(pair, Status.CONTAIN_SAME_ELEMENTS);
        } else {
            AssertIterableEquals.assertIterablesNotNull(expected, actual, indexes, messageOrSupplier);
            AssertIterableEquals.failIterablesNotEqual(expected, actual, indexes, messageOrSupplier);
        }
    }

    private static void assertIterablesNotNull(Object expected, Object actual, Deque<Integer> indexes, Object messageOrSupplier) {
        if (expected == null) {
            AssertIterableEquals.failExpectedIterableIsNull(indexes, messageOrSupplier);
        }
        if (actual == null) {
            AssertIterableEquals.failActualIterableIsNull(indexes, messageOrSupplier);
        }
    }

    private static void failExpectedIterableIsNull(Deque<Integer> indexes, Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("expected iterable was <null>" + AssertionUtils.formatIndexes(indexes)).buildAndThrow();
    }

    private static void failActualIterableIsNull(Deque<Integer> indexes, Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("actual iterable was <null>" + AssertionUtils.formatIndexes(indexes)).buildAndThrow();
    }

    private static void assertIteratorsAreEmpty(Iterator<?> expected, Iterator<?> actual, int processed, Deque<Integer> indexes, Object messageOrSupplier) {
        if (expected.hasNext() || actual.hasNext()) {
            AtomicInteger expectedCount = new AtomicInteger(processed);
            expected.forEachRemaining(e -> expectedCount.incrementAndGet());
            AtomicInteger actualCount = new AtomicInteger(processed);
            actual.forEachRemaining(e -> actualCount.incrementAndGet());
            AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("iterable lengths differ" + AssertionUtils.formatIndexes(indexes)).expected(expectedCount.get()).actual(actualCount.get()).buildAndThrow();
        }
    }

    private static void failIterablesNotEqual(Object expected, Object actual, Deque<Integer> indexes, Object messageOrSupplier) {
        AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("iterable contents differ" + AssertionUtils.formatIndexes(indexes)).expected(expected).actual(actual).buildAndThrow();
    }

    private static final class Pair {
        private final Object left;
        private final Object right;

        public Pair(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair that = (Pair)o;
            return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }
    }

    private static enum Status {
        UNDER_INVESTIGATION,
        CONTAIN_SAME_ELEMENTS;

    }
}

