/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.occurrences;

import com.google.common.base.Preconditions;
import com.google.inject.ImplementedBy;
import com.google.inject.Singleton;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.util.ITextRegion;

@ImplementedBy(value=Default.class)
public interface ITextRegionTransformer {
    public DocumentHighlight apply(Document var1, ITextRegion var2, DocumentHighlightKind var3);

    @Singleton
    public static final class Default
    implements ITextRegionTransformer {
        @Override
        public DocumentHighlight apply(Document document, ITextRegion region, DocumentHighlightKind kind) {
            Preconditions.checkNotNull((Object)document, (Object)"document");
            Preconditions.checkNotNull((Object)region, (Object)"region");
            Preconditions.checkNotNull((Object)kind, (Object)"kind");
            int offset = region.getOffset();
            Position start = document.getPosition(offset);
            Position end = document.getPosition(region.getEndOffset());
            return new DocumentHighlight(new Range(start, end), kind);
        }
    }
}

