/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTContentAssistantProcessor;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTHtmlCompletionProcessor;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTProposalCollector;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTTemplateAssistProcessor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;

public class JSDTContentAssistant
extends AbstractContentAssistProcessor
implements ICompletionProposalComputer {
    private JSDTContentAssistantProcessor fContentAssistProcessor;
    private JSDTTemplateAssistProcessor fTemplateAssistProcessor;
    private JSDTHtmlCompletionProcessor fHhtmlcomp;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition) {
        Vector<ICompletionProposal> proposals = new Vector<ICompletionProposal>();
        ICompletionProposal endScript = this.getHtmlContentAssistProcessor().getEndScriptProposal(viewer, documentPosition);
        if (endScript != null) {
            return new ICompletionProposal[]{endScript};
        }
        JSDTProposalCollector theCollector = this.getProposalCollector(viewer, documentPosition);
        if (theCollector == null) {
            return new ICompletionProposal[0];
        }
        this.getContentAssistProcessor().setProposalCollector(theCollector);
        ICompletionProposal[] completionProposals = this.getContentAssistProcessor().computeCompletionProposals(viewer, documentPosition);
        proposals.addAll(Arrays.asList(completionProposals));
        completionProposals = this.getHtmlContentAssistProcessor().computeCompletionProposals(viewer, documentPosition);
        proposals.addAll(Arrays.asList(completionProposals));
        this.getTemplateCompletionProcessor().setProposalCollector(theCollector);
        completionProposals = this.getTemplateCompletionProcessor().computeCompletionProposals(viewer, documentPosition);
        proposals.addAll(Arrays.asList(completionProposals));
        return proposals.toArray(new ICompletionProposal[0]);
    }

    private JSDTHtmlCompletionProcessor getHtmlContentAssistProcessor() {
        if (this.fHhtmlcomp == null) {
            this.fHhtmlcomp = new JSDTHtmlCompletionProcessor();
        }
        return this.fHhtmlcomp;
    }

    private JSDTContentAssistantProcessor getContentAssistProcessor() {
        if (this.fContentAssistProcessor == null) {
            this.fContentAssistProcessor = new JSDTContentAssistantProcessor();
        }
        return this.fContentAssistProcessor;
    }

    private IJsTranslation getJSPTranslation(ITextViewer viewer, int offset) {
        IDOMModel xmlModel = null;
        try {
            xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
            IDOMDocument xmlDoc = xmlModel.getDocument();
            JsTranslationAdapter translationAdapter = (JsTranslationAdapter)xmlDoc.getAdapterFor(IJsTranslation.class);
            if (translationAdapter != null) {
                IJsTranslation iJsTranslation = translationAdapter.getJsTranslation(true);
                return iJsTranslation;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromRead();
            }
        }
        return null;
    }

    protected JSDTProposalCollector getProposalCollector(ITextViewer viewer, int offset) {
        IJsTranslation tran = this.getJSPTranslation(viewer, offset);
        if (tran == null) {
            return null;
        }
        return new JSDTProposalCollector(tran);
    }

    private JSDTTemplateAssistProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateAssistProcessor == null) {
            this.fTemplateAssistProcessor = new JSDTTemplateAssistProcessor();
        }
        return this.fTemplateAssistProcessor;
    }

    public void sessionStarted() {
    }

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        Vector<ICompletionProposal> proposals = new Vector<ICompletionProposal>();
        ICompletionProposal endScript = this.getHtmlContentAssistProcessor().getEndScriptProposal(context.getViewer(), context.getInvocationOffset());
        if (endScript != null) {
            return new ArrayList(0);
        }
        JSDTProposalCollector theCollector = this.getProposalCollector(context.getViewer(), context.getInvocationOffset());
        if (theCollector == null) {
            return new ArrayList(0);
        }
        theCollector.setAllowsRequiredProposals(26, 9, true);
        this.getContentAssistProcessor().setProposalCollector(theCollector);
        ICompletionProposal[] completionProposals = this.getContentAssistProcessor().computeCompletionProposals(context.getViewer(), context.getInvocationOffset());
        proposals.addAll(Arrays.asList(completionProposals));
        completionProposals = this.getHtmlContentAssistProcessor().computeCompletionProposals(context.getViewer(), context.getInvocationOffset());
        proposals.addAll(Arrays.asList(completionProposals));
        this.getTemplateCompletionProcessor().setProposalCollector(theCollector);
        completionProposals = this.getTemplateCompletionProcessor().computeCompletionProposals(context.getViewer(), context.getInvocationOffset());
        proposals.addAll(Arrays.asList(completionProposals));
        return proposals;
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Arrays.asList(this.computeContextInformation(context.getViewer(), context.getInvocationOffset()));
    }

    public void sessionEnded() {
        this.fContentAssistProcessor = null;
        this.fTemplateAssistProcessor = null;
        this.fHhtmlcomp = null;
    }
}

