/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;

public abstract class FilePropertyTester
extends PropertyTester {
    private static final String IS_JS_FILE_PROPERTY = "isJsFile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IFile file = this.extractFile(receiver);
        if (IS_JS_FILE_PROPERTY.equals(property)) {
            return FilePropertyTester.testIsJsFile(file);
        }
        throw new RuntimeException("Unrecognized property name");
    }

    protected abstract IFile extractFile(Object var1);

    private static boolean testIsJsFile(IFile file) {
        return ChromiumDebugPluginUtil.SUPPORTED_EXTENSIONS.contains(file.getFileExtension());
    }

    public static class ForFile
    extends FilePropertyTester {
        @Override
        protected IFile extractFile(Object receiver) {
            return (IFile)receiver;
        }
    }
}

