/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.IterableUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.BasePartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;

public abstract class AbstractCyclicPartialRegionsAnalysis<@NonNull PRA extends PartialRegionsAnalysis<@NonNull PRA>> {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void showCycles(@NonNull TracingOption cyclesTracingOption, @NonNull Iterable<? extends @NonNull PartialRegionAnalysis<@NonNull PRA>> cyclicRegionAnalyses) {
        @NonNull @NonNull ArrayList sortedCyclicRegionAnalyses = Lists.newArrayList(cyclicRegionAnalyses);
        if (sortedCyclicRegionAnalyses.isEmpty()) {
            cyclesTracingOption.println("No cycles");
            return;
        }
        Collections.sort(sortedCyclicRegionAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionAnalysis cyclicRegionAnalysis : sortedCyclicRegionAnalyses) {
            StringBuilder s = new StringBuilder();
            s.append(cyclicRegionAnalysis.getName());
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> consumedClassAnalyses = cyclicRegionAnalysis.getConsumedClassAnalyses();
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> superProducedClassAnalyses = cyclicRegionAnalysis.getSuperProducedClassAnalyses();
            Set cyclicClassAnalyses = null;
            if (consumedClassAnalyses != null) {
                if (superProducedClassAnalyses != null) {
                    cyclicClassAnalyses = Sets.newHashSet(consumedClassAnalyses);
                    IterableUtil.retainAll((Collection)cyclicClassAnalyses, superProducedClassAnalyses);
                }
                s.append("\n  ConsumedClassAnalyses:");
                @NonNull @NonNull ArrayList sortedConsumedClassAnalyses = Lists.newArrayList(consumedClassAnalyses);
                if (cyclicClassAnalyses != null) {
                    sortedConsumedClassAnalyses.removeAll(cyclicClassAnalyses);
                }
                Collections.sort(sortedConsumedClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionClassAnalysis consumedClassAnalysis : sortedConsumedClassAnalyses) {
                    s.append("\n\t" + consumedClassAnalysis);
                }
            }
            if (cyclicClassAnalyses != null && !cyclicClassAnalyses.isEmpty()) {
                s.append("\n  CyclicClassAnalyses:");
                @NonNull @NonNull ArrayList sortedCyclicClassAnalyses = Lists.newArrayList((Iterable)cyclicClassAnalyses);
                Collections.sort(sortedCyclicClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionClassAnalysis cyclicClassAnalysis : sortedCyclicClassAnalyses) {
                    s.append("\n\t" + cyclicClassAnalysis);
                }
            }
            if (superProducedClassAnalyses != null) {
                s.append("\n  ProducedClassAnalyses:");
                @NonNull @NonNull ArrayList sortedSuperProducedClassAnalyses = Lists.newArrayList(superProducedClassAnalyses);
                if (cyclicClassAnalyses != null) {
                    sortedSuperProducedClassAnalyses.removeAll(cyclicClassAnalyses);
                }
                Collections.sort(sortedSuperProducedClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionClassAnalysis producedClassAnalysis : sortedSuperProducedClassAnalyses) {
                    s.append("\n\t" + producedClassAnalysis);
                }
            }
            Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> consumedPropertyAnalyses = cyclicRegionAnalysis.getConsumedPropertyAnalyses();
            Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull PRA>> producedPropertyAnalyses = cyclicRegionAnalysis.getProducedPropertyAnalyses();
            Set cyclicPropertyAnalyses = null;
            if (consumedPropertyAnalyses != null) {
                if (producedPropertyAnalyses != null) {
                    cyclicPropertyAnalyses = Sets.newHashSet(consumedPropertyAnalyses);
                    IterableUtil.retainAll((Collection)cyclicPropertyAnalyses, producedPropertyAnalyses);
                }
                s.append("\n  ConsumedPropertyAnalyses:");
                @NonNull @NonNull ArrayList sortedConsumedPropertyAnalyses = Lists.newArrayList(consumedPropertyAnalyses);
                if (cyclicPropertyAnalyses != null) {
                    sortedConsumedPropertyAnalyses.removeAll(cyclicPropertyAnalyses);
                }
                Collections.sort(sortedConsumedPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionPropertyAnalysis consumedPropertyAnalysis : sortedConsumedPropertyAnalyses) {
                    s.append("\n\t" + consumedPropertyAnalysis);
                    BasePartialRegionPropertyAnalysis<@NonNull PRA> baseConsumedPropertyAnalysis = consumedPropertyAnalysis.getBasePropertyAnalysis();
                    if (consumedPropertyAnalysis.getPropertyDatum() == baseConsumedPropertyAnalysis.getPropertyDatum()) continue;
                    s.append("(" + baseConsumedPropertyAnalysis + ")");
                }
            }
            if (cyclicPropertyAnalyses != null && !cyclicPropertyAnalyses.isEmpty()) {
                s.append("\n  CyclicPropertyAnalyses:");
                @NonNull @NonNull ArrayList sortedCyclicPropertyAnalyses = Lists.newArrayList((Iterable)cyclicPropertyAnalyses);
                Collections.sort(sortedCyclicPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionPropertyAnalysis cyclicPropertyAnalysis : sortedCyclicPropertyAnalyses) {
                    s.append("\n\t" + cyclicPropertyAnalysis);
                    BasePartialRegionPropertyAnalysis<@NonNull PRA> baseCyclicPropertyAnalysis = cyclicPropertyAnalysis.getBasePropertyAnalysis();
                    if (cyclicPropertyAnalysis.getPropertyDatum() == baseCyclicPropertyAnalysis.getPropertyDatum()) continue;
                    s.append("(" + baseCyclicPropertyAnalysis + ")");
                }
            }
            if (producedPropertyAnalyses != null) {
                s.append("\n  ProducedPropertyAnalyses:");
                @NonNull @NonNull ArrayList sortedProducedPropertyAnalyses = Lists.newArrayList(producedPropertyAnalyses);
                if (cyclicPropertyAnalyses != null) {
                    sortedProducedPropertyAnalyses.removeAll(cyclicPropertyAnalyses);
                }
                Collections.sort(sortedProducedPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionPropertyAnalysis producedPropertyAnalysis : sortedProducedPropertyAnalyses) {
                    s.append("\n\t" + producedPropertyAnalysis);
                    BasePartialRegionPropertyAnalysis<@NonNull PRA> baseProducedPropertyAnalysis = producedPropertyAnalysis.getBasePropertyAnalysis();
                    if (producedPropertyAnalysis.getPropertyDatum() == baseProducedPropertyAnalysis.getPropertyDatum()) continue;
                    s.append("(" + baseProducedPropertyAnalysis + ")");
                }
            }
            cyclesTracingOption.println(s.toString());
        }
    }
}

