/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class PHPConventionsUtil {
    public static boolean validateIdentifier(String newName) {
        if (newName == null || newName.length() == 0 || !Character.isLetter(newName.charAt(0)) && newName.charAt(0) != '_') {
            return false;
        }
        int length = newName.length();
        int i = 1;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(newName.charAt(i))) {
                return false;
            }
            if (newName.charAt(i) == '$') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateFieldName(String text) {
        if (PHPConventionsUtil.validateIdentifier(text)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.php.refactoring.ui", "Error Parameter name");
    }

    public static boolean startsWithLowerCase(String text) {
        return text != null && text.length() != 0 && Character.isLowerCase(text.charAt(0));
    }

    public static RefactoringStatus checkParameterTypeSyntax(String type, IScriptProject scriptProject) {
        return null;
    }
}

