/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.container;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.net4j.util.ui.container.ElementWizardComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementWizardDialog
extends TitleAreaDialog
implements ValidationContext {
    private String title;
    private String toolTip;
    private String productGroup;
    private String factoryType;
    private String description;
    private String defaultFactoryType;
    private ElementWizardComposite wizardComposite;

    public ElementWizardDialog(Shell parentShell, String title, String toolTip, String productGroup, String defaultFactoryType) {
        super(parentShell);
        this.title = title;
        this.toolTip = toolTip;
        this.productGroup = productGroup;
        this.defaultFactoryType = defaultFactoryType;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public String getTitle() {
        return this.title;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public String getProductGroup() {
        return this.productGroup;
    }

    public String getFactoryType() {
        return this.factoryType;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void setValidationError(Object source, String message) {
        this.setMessage(message, 3);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        if (this.toolTip != null) {
            this.setMessage(this.toolTip);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.wizardComposite = new ElementWizardComposite.WithRadios(composite, 0, this.productGroup, "Type:", this, this.defaultFactoryType){

            @Override
            public String getDefaultDescription(String factoryType) {
                return ElementWizardDialog.this.getDefaultDescription(factoryType);
            }
        };
        this.wizardComposite.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        return composite;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected String getDefaultDescription(String factoryType) {
        return null;
    }

    protected void okPressed() {
        this.factoryType = this.wizardComposite.getFactoryType();
        this.description = this.wizardComposite.getDescription();
        super.okPressed();
    }
}

