/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.core.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.eclipse.m2m.atl.profiler.core.ProfilerModelHandler;
import org.eclipse.m2m.atl.profiler.core.util.ProfilingModelUtils;
import org.eclipse.m2m.atl.profiler.exportmodel.AtlOperationExport;
import org.eclipse.m2m.atl.profiler.exportmodel.ExportRoot;
import org.eclipse.m2m.atl.profiler.exportmodel.ExportmodelFactory;
import org.eclipse.m2m.atl.profiler.exportmodel.ProfilingOperationExport;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingInstruction;
import org.eclipse.m2m.atl.profiler.model.ProfilingModel;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

public final class ProfilerModelExporter {
    private ProfilerModelExporter() {
    }

    public static ExportRoot exportCurrentProfilingModel() throws Exception {
        ExportRoot exportModel = null;
        ProfilingModel profilingModel = ProfilerModelHandler.getInstance().getProfilingModel();
        if (profilingModel != null) {
            exportModel = ExportmodelFactory.eINSTANCE.createExportRoot();
            Map<String, ATLOperation> atlOperationRegistry = ProfilerModelHandler.getInstance().getOperationRegistry();
            double globalTime = (double)(profilingModel.getEndTime() - profilingModel.getLaunchedTime()) / 1000.0;
            long totalExecutedInstructions = profilingModel.getTotalExecutedInstructions();
            exportModel.setTotalTime(globalTime);
            exportModel.setTotalInstructions(totalExecutedInstructions);
            NumberFormat nf = DecimalFormat.getNumberInstance(Locale.ENGLISH);
            nf.setMaximumFractionDigits(3);
            NumberFormat percentFormat = DecimalFormat.getPercentInstance(Locale.ENGLISH);
            percentFormat.setMaximumFractionDigits(3);
            for (ATLOperation atlOperation : atlOperationRegistry.values()) {
                AtlOperationExport atlOperationExport = ExportmodelFactory.eINSTANCE.createAtlOperationExport();
                double atlOpTime = 0.0;
                long atlOpExecutedinstructions = 0L;
                long atlOpInMemory = 0L;
                long atlOpMaxMemory = 0L;
                long atlOpMaxEndMemory = 0L;
                for (ProfilingInstruction pi : atlOperation.getProfilingInstructions()) {
                    if (!(pi instanceof ProfilingOperation)) continue;
                    ProfilingOperation profilingOperation = (ProfilingOperation)pi;
                    ProfilingOperationExport profilingOperationExport = ExportmodelFactory.eINSTANCE.createProfilingOperationExport();
                    profilingOperationExport.setName(profilingOperation.getContent());
                    double duration = ProfilingModelUtils.getDuration(profilingOperation);
                    profilingOperationExport.setTimExecution(duration);
                    atlOpTime += duration;
                    double pDuration = duration / globalTime;
                    profilingOperationExport.setTotalTimeExecutionPercent(percentFormat.format(pDuration));
                    int profOpexecutedinstructions = profilingOperation.getTotalExecutedInstructions();
                    profilingOperationExport.setInstructions((long)profOpexecutedinstructions);
                    atlOpExecutedinstructions += (long)profOpexecutedinstructions;
                    double ptotalInstructions = (double)profOpexecutedinstructions / (double)totalExecutedInstructions;
                    profilingOperationExport.setTotalInstructionsPercent(percentFormat.format(ptotalInstructions));
                    long launchKbytesMemUsage = ProfilingModelUtils.getLaunchKbytesMemUsage(profilingOperation);
                    profilingOperationExport.setBeginMemory(launchKbytesMemUsage);
                    if (atlOpInMemory == 0L) {
                        atlOpInMemory = launchKbytesMemUsage;
                    } else if (launchKbytesMemUsage < atlOpInMemory) {
                        atlOpInMemory = launchKbytesMemUsage;
                    }
                    long maxKbytesMemUsage = ProfilingModelUtils.getMaxKbytesMemUsage(profilingOperation);
                    profilingOperationExport.setMaxMemory(maxKbytesMemUsage);
                    if (atlOpMaxMemory == 0L) {
                        atlOpMaxMemory = maxKbytesMemUsage;
                    } else if (maxKbytesMemUsage < atlOpMaxMemory) {
                        atlOpMaxMemory = maxKbytesMemUsage;
                    }
                    long endKbytesMemUsage = ProfilingModelUtils.getEndKbytesMemUsage(profilingOperation);
                    profilingOperationExport.setEndMemory(endKbytesMemUsage);
                    if (atlOpMaxEndMemory == 0L) {
                        atlOpMaxEndMemory = endKbytesMemUsage;
                    } else if (endKbytesMemUsage < atlOpMaxEndMemory) {
                        atlOpMaxEndMemory = endKbytesMemUsage;
                    }
                    atlOperationExport.getProfilingOperation().add((Object)profilingOperationExport);
                }
                atlOperationExport.setName(atlOperation.getName());
                Double dAtlOpTime = new Double(nf.format(atlOpTime));
                atlOperationExport.setTimExecution(dAtlOpTime.doubleValue());
                atlOperationExport.setInstructions(atlOpExecutedinstructions);
                atlOperationExport.setBeginMemory(atlOpInMemory);
                atlOperationExport.setMaxMemory(atlOpMaxMemory);
                atlOperationExport.setEndMemory(atlOpMaxEndMemory);
                double pAtlOpExecutedinstructions = (double)atlOpExecutedinstructions / (double)totalExecutedInstructions;
                atlOperationExport.setTotalInstructionsPercent(percentFormat.format(pAtlOpExecutedinstructions));
                double pAtlOpTime = atlOpTime / globalTime;
                atlOperationExport.setTotalTimeExecutionPercent(percentFormat.format(pAtlOpTime));
                exportModel.getOperation().add((Object)atlOperationExport);
            }
        }
        return exportModel;
    }
}

