/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.history.CommitSelectionDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CompareWithCommitActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(true, event);
        if (repo == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        CommitSelectionDialog dlg = new CommitSelectionDialog(this.getShell(event), repo, resources);
        if (dlg.open() != 0) {
            return null;
        }
        String commitId = dlg.getCommitId().getName();
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            CompareUtils.compare(resources, repo, "HEAD", commitId, true, workbenchPage);
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }
}

