/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ITopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.TopologyManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

public class TopologyManager
implements EventListenerHook,
RemoteServiceAdminListener,
ITopologyManager {
    private Map<Bundle, List<EndpointEventHolder>> bundleEndpointEventListenerMap = new HashMap<Bundle, List<EndpointEventHolder>>();
    protected TopologyManagerImpl topologyManagerImpl;
    protected ServiceRegistration<?> endpointListenerRegistration;
    ServiceRegistration<?> legacyEndpointListenerRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFrameworkUUID(BundleContext context) {
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String result = context.getProperty("org.osgi.framework.uuid");
            if (result == null) {
                UUID newUUID = UUID.randomUUID();
                result = newUUID.toString();
                System.setProperty("org.osgi.framework.uuid", newUUID.toString());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    protected TopologyManagerImpl createTopologyManagerImpl(BundleContext context, boolean allowLocalhost, String[] extraFilters) {
        return new TopologyManagerImpl(context, allowLocalhost, extraFilters);
    }

    protected void activate(BundleContext context, Map<String, ?> properties) throws Exception {
        String exportRegisteredSvcsFilter;
        String extraFilters;
        Boolean allowLocalhost = (Boolean)properties.get("allowLocalhost");
        if (allowLocalhost == null) {
            allowLocalhost = ENDPOINT_ALLOWLOCALHOST;
        }
        extraFilters = (extraFilters = (String)properties.get("extraFilters")) != null ? extraFilters : ENDPOINT_EXTRA_FILTERS;
        String[] extraFiltersArr = null;
        if (extraFilters != null) {
            extraFiltersArr = extraFilters.split(",");
        }
        this.topologyManagerImpl = this.createTopologyManagerImpl(context, allowLocalhost, extraFiltersArr);
        Dictionary<String, Object> props = this.createEndpointListenerProps(Arrays.asList(this.topologyManagerImpl.getScope()));
        this.endpointListenerRegistration = context.registerService(EndpointEventListener.class, (ServiceFactory)new ServiceFactory<EndpointEventListener>(){

            public EndpointEventListener getService(Bundle bundle, ServiceRegistration<EndpointEventListener> registration) {
                return new ProxyEndpointEventListener(bundle);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ungetService(Bundle bundle, ServiceRegistration<EndpointEventListener> registration, EndpointEventListener service) {
                ProxyEndpointEventListener peel;
                ProxyEndpointEventListener proxyEndpointEventListener = peel = service instanceof ProxyEndpointEventListener ? (ProxyEndpointEventListener)service : null;
                if (peel == null) {
                    return;
                }
                Map<Bundle, List<EndpointEventHolder>> map = TopologyManager.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    List<EndpointEventHolder> endpointEventHolders = TopologyManager.this.bundleEndpointEventListenerMap.get(bundle);
                    if (endpointEventHolders != null) {
                        for (EndpointEventHolder eh : endpointEventHolders) {
                            peel.deliverRemoveEventForBundle(eh);
                        }
                    }
                }
            }
        }, props);
        if (this.topologyManagerImpl.isNonECFTopologyManager()) {
            this.legacyEndpointListenerRegistration = context.registerService(EndpointListener.class, (ServiceFactory)new ServiceFactory<EndpointListener>(){

                public EndpointListener getService(Bundle bundle, ServiceRegistration<EndpointListener> registration) {
                    return new ProxyEndpointListener(bundle);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void ungetService(Bundle bundle, ServiceRegistration<EndpointListener> registration, EndpointListener service) {
                    ProxyEndpointListener peel;
                    ProxyEndpointListener proxyEndpointListener = peel = service instanceof ProxyEndpointListener ? (ProxyEndpointListener)service : null;
                    if (peel == null) {
                        return;
                    }
                    Map<Bundle, List<EndpointEventHolder>> map = TopologyManager.this.bundleEndpointEventListenerMap;
                    synchronized (map) {
                        List<EndpointEventHolder> endpointEventHolders = TopologyManager.this.bundleEndpointEventListenerMap.get(bundle);
                        if (endpointEventHolders != null) {
                            for (EndpointEventHolder eh : endpointEventHolders) {
                                peel.deliverRemoveEventForBundle(eh);
                            }
                        }
                    }
                }
            }, props);
        }
        if ((exportRegisteredSvcsFilter = (String)properties.get("exportRegisteredServicesFilter")) == null) {
            exportRegisteredSvcsFilter = EXPORT_REGISTERED_SERVICES_FILTER;
        }
        this.topologyManagerImpl.exportRegisteredServices(exportRegisteredSvcsFilter);
    }

    protected Dictionary<String, Object> createEndpointListenerProps(List<String> filters) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("endpoint.listener.scope", filters.toArray(new String[filters.size()]));
        return props;
    }

    protected void deactivate() {
        if (this.legacyEndpointListenerRegistration != null) {
            this.legacyEndpointListenerRegistration.unregister();
            this.legacyEndpointListenerRegistration = null;
        }
        if (this.endpointListenerRegistration != null) {
            this.endpointListenerRegistration.unregister();
            this.endpointListenerRegistration = null;
        }
        if (this.topologyManagerImpl != null) {
            this.topologyManagerImpl.close();
            this.topologyManagerImpl = null;
        }
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        this.topologyManagerImpl.handleRemoteAdminEvent(event);
    }

    public void event(ServiceEvent event, Map listeners) {
        this.topologyManagerImpl.handleEvent(event, listeners);
    }

    @Override
    public String[] getEndpointFilters() {
        return this.topologyManagerImpl.getScope();
    }

    @Override
    public String[] setEndpointFilters(String[] newFilters) {
        return null;
    }

    class EndpointEventHolder {
        private final EndpointDescription endpointDescription;
        private final String filter;

        public EndpointEventHolder(EndpointDescription d, String f) {
            this.endpointDescription = d;
            this.filter = f;
        }

        public EndpointDescription getEndpoint() {
            return this.endpointDescription;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    class ProxyEndpointEventListener
    implements EndpointEventListener {
        private final Bundle bundle;

        public ProxyEndpointEventListener(Bundle b) {
            this.bundle = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endpointChanged(EndpointEvent event, String filter) {
            int type = event.getType();
            if (type == 1) {
                Map<Bundle, List<EndpointEventHolder>> map = TopologyManager.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    List<EndpointEventHolder> endpointEventHolders = TopologyManager.this.bundleEndpointEventListenerMap.get(this.bundle);
                    if (endpointEventHolders == null) {
                        endpointEventHolders = new ArrayList<EndpointEventHolder>();
                    }
                    endpointEventHolders.add(new EndpointEventHolder(event.getEndpoint(), filter));
                    TopologyManager.this.bundleEndpointEventListenerMap.put(this.bundle, endpointEventHolders);
                }
            }
            if (type == 2) {
                Map<Bundle, List<EndpointEventHolder>> map = TopologyManager.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    List<EndpointEventHolder> endpointEventHolders = TopologyManager.this.bundleEndpointEventListenerMap.get(this.bundle);
                    if (endpointEventHolders != null) {
                        Iterator<EndpointEventHolder> i = endpointEventHolders.iterator();
                        while (i.hasNext()) {
                            EndpointDescription newEd;
                            EndpointEventHolder eh = i.next();
                            EndpointDescription oldEd = eh.getEndpoint();
                            if (!oldEd.equals((Object)(newEd = event.getEndpoint()))) continue;
                            i.remove();
                        }
                        if (endpointEventHolders.size() == 0) {
                            TopologyManager.this.bundleEndpointEventListenerMap.remove(this.bundle);
                        }
                    }
                }
            }
            this.deliverSafe(event, filter);
        }

        private void logError(String methodName, String message, Throwable e) {
            LogUtility.logError(methodName == null ? "<unknown>" : methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", TopologyManager.class, message == null ? "<empty>" : message, e);
        }

        private void deliverSafe(final EndpointEvent endpointEvent, final String matchingFilter) {
            final TopologyManagerImpl listener = TopologyManager.this.topologyManagerImpl;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (listener != null) {
                        listener.endpointChanged(endpointEvent, matchingFilter);
                    }
                }

                public void handleException(Throwable exception) {
                    String message = "Exception in EndpointEventListener listener=" + String.valueOf(listener) + " event=" + String.valueOf(endpointEvent) + " matchingFilter=" + matchingFilter;
                    ProxyEndpointEventListener.this.logError("deliverSafe", message, exception);
                }
            });
        }

        public void deliverRemoveEventForBundle(EndpointEventHolder eventHolder) {
            this.deliverSafe(new EndpointEvent(2, eventHolder.getEndpoint()), eventHolder.getFilter());
        }
    }

    class ProxyEndpointListener
    implements EndpointListener {
        private final Bundle bundle;

        public ProxyEndpointListener(Bundle b) {
            this.bundle = b;
        }

        private void logError(String methodName, String message, Throwable e) {
            LogUtility.logError(methodName == null ? "<unknown>" : methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", TopologyManager.class, message == null ? "<empty>" : message, e);
        }

        private void deliverSafe(final EndpointDescription endpoint, final String matchingFilter, final boolean added) {
            final TopologyManagerImpl listener = TopologyManager.this.topologyManagerImpl;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (added) {
                        listener.endpointAdded(endpoint, matchingFilter);
                    } else {
                        listener.endpointRemoved(endpoint, matchingFilter);
                    }
                }

                public void handleException(Throwable exception) {
                    String message = "Exception in EndpointListener listener=" + String.valueOf(listener) + " endpoint=" + String.valueOf(endpoint) + " matchingFilter=" + matchingFilter + " added=" + added;
                    ProxyEndpointListener.this.logError("deliverSafe", message, exception);
                }
            });
        }

        public void deliverRemoveEventForBundle(EndpointEventHolder eventHolder) {
            this.deliverSafe(eventHolder.getEndpoint(), eventHolder.getFilter(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
            Map<Bundle, List<EndpointEventHolder>> map = TopologyManager.this.bundleEndpointEventListenerMap;
            synchronized (map) {
                List<EndpointEventHolder> endpointEventHolders = TopologyManager.this.bundleEndpointEventListenerMap.get(this.bundle);
                if (endpointEventHolders == null) {
                    endpointEventHolders = new ArrayList<EndpointEventHolder>();
                }
                endpointEventHolders.add(new EndpointEventHolder(endpoint, matchedFilter));
                TopologyManager.this.bundleEndpointEventListenerMap.put(this.bundle, endpointEventHolders);
            }
            this.deliverSafe(endpoint, matchedFilter, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
            Map<Bundle, List<EndpointEventHolder>> map = TopologyManager.this.bundleEndpointEventListenerMap;
            synchronized (map) {
                List<EndpointEventHolder> endpointEventHolders = TopologyManager.this.bundleEndpointEventListenerMap.get(this.bundle);
                if (endpointEventHolders != null) {
                    Iterator<EndpointEventHolder> i = endpointEventHolders.iterator();
                    while (i.hasNext()) {
                        EndpointDescription newEd;
                        EndpointEventHolder eh = i.next();
                        EndpointDescription oldEd = eh.getEndpoint();
                        if (!oldEd.equals((Object)(newEd = endpoint))) continue;
                        i.remove();
                    }
                    if (endpointEventHolders.size() == 0) {
                        TopologyManager.this.bundleEndpointEventListenerMap.remove(this.bundle);
                    }
                }
            }
            this.deliverSafe(endpoint, matchedFilter, false);
        }
    }
}

