/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.editor;

import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;

public abstract class AbstractRowData
implements IRowData {
    protected int state;
    public static final int STATE_ORIGINAL = 0;
    public static final int STATE_UPDATED = 1;
    public static final int STATE_DELETED = 2;
    public static final int STATE_INSERTED = 3;
    protected Object[] newData;
    protected Object[] oldData;

    public AbstractRowData(int state, Object[] data) {
        this.state = state;
        this.newData = data;
        if (state == 0) {
            this.oldData = (Object[])data.clone();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void resetToOriginal() {
        this.state = 0;
        this.oldData = (Object[])this.newData.clone();
    }

    public void revertToOriginal() {
        this.state = 0;
        this.newData = (Object[])this.oldData.clone();
    }

    @Override
    public Object getValue(int col) {
        return this.newData[col];
    }

    @Override
    public void updateValue(int col, Object value) {
        if (this.state == 0) {
            this.state = 1;
        }
        this.newData[col] = value;
    }
}

