/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.runtime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeManager;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.runtime.RuntimeMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSRuntimesDefinitionsContainer {
    private Map<IJSRuntimeType, List<IJSRuntimeInstall>> fRuntimeTypeToInstallMap = new HashMap<IJSRuntimeType, List<IJSRuntimeInstall>>(10);
    private Map<String, String> fRuntimeTypeDefaultMap = new HashMap<String, String>(10);
    private List<IJSRuntimeInstall> fRuntimeList = new ArrayList<IJSRuntimeInstall>(10);

    public void addRuntime(IJSRuntimeInstall runtime) {
        if (!this.fRuntimeList.contains(runtime)) {
            IJSRuntimeType runtimeType = runtime.getRuntimeType();
            List<IJSRuntimeInstall> runtimeList = this.fRuntimeTypeToInstallMap.get(runtimeType);
            if (runtimeList == null) {
                runtimeList = new ArrayList<IJSRuntimeInstall>(3);
                this.fRuntimeTypeToInstallMap.put(runtimeType, runtimeList);
            }
            runtimeList.add(runtime);
            this.fRuntimeList.add(runtime);
        }
    }

    public List<IJSRuntimeInstall> getRuntimeList() {
        return this.fRuntimeList;
    }

    public String getAsXML() throws CoreException {
        Document doc = DebugPlugin.newDocument();
        Element config = doc.createElement("runtimeSettings");
        doc.appendChild(config);
        Set<IJSRuntimeType> runtimeTypeSet = this.fRuntimeTypeToInstallMap.keySet();
        for (IJSRuntimeType runtimeType : runtimeTypeSet) {
            Element runtimeTypeElement = this.runtimeTypeAsElement(doc, runtimeType);
            config.appendChild(runtimeTypeElement);
        }
        return DebugPlugin.serializeDocument((Document)doc);
    }

    public void setDefaultRuntimeInstallId(String runtimeTypeId, String runtimeInstallId) {
        this.fRuntimeTypeDefaultMap.put(runtimeTypeId, runtimeInstallId);
    }

    public String getDefaultRuntimeInstallId(String runtimeTypeId) {
        return this.fRuntimeTypeDefaultMap.get(runtimeTypeId);
    }

    private Element runtimeTypeAsElement(Document doc, IJSRuntimeType runtimeType) {
        Element element = doc.createElement("runtimeType");
        element.setAttribute("id", runtimeType.getId());
        if (this.getDefaultRuntimeInstallId(runtimeType.getId()) != null) {
            element.setAttribute("defaultRuntime", this.getDefaultRuntimeInstallId(runtimeType.getId()));
        }
        List<IJSRuntimeInstall> runtimeList = this.fRuntimeTypeToInstallMap.get(runtimeType);
        for (IJSRuntimeInstall runtime : runtimeList) {
            Element runtimeElement = this.runtimeInstallAsElement(doc, runtime);
            element.appendChild(runtimeElement);
        }
        return element;
    }

    private Element runtimeInstallAsElement(Document doc, IJSRuntimeInstall runtimeInstall) {
        Element element = doc.createElement("runtime");
        element.setAttribute("id", runtimeInstall.getId());
        element.setAttribute("name", runtimeInstall.getName());
        String installPath = "";
        File installLocation = runtimeInstall.getInstallLocation();
        if (installLocation != null) {
            installPath = installLocation.getAbsolutePath();
        }
        element.setAttribute("path", installPath);
        String runtimeArgs = runtimeInstall.getJSRuntimeArgumentsAsString();
        if (runtimeArgs != null && runtimeArgs.length() > 0) {
            element.setAttribute("runtimeArgs", runtimeArgs);
        }
        return element;
    }

    public static JSRuntimesDefinitionsContainer parseXMLIntoContainer(InputStream inputStream) throws IOException {
        JSRuntimesDefinitionsContainer container = new JSRuntimesDefinitionsContainer();
        JSRuntimesDefinitionsContainer.parseXMLIntoContainer(inputStream, container);
        return container;
    }

    public static void parseXMLIntoContainer(InputStream inputStream, JSRuntimesDefinitionsContainer container) throws IOException {
        Element config = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedInputStream stream = new BufferedInputStream(inputStream);){
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(RuntimeMessages.JSRuntimeDefinitionsContainer_WrongXMLFormat_Error);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(RuntimeMessages.JSRuntimeDefinitionsContainer_WrongXMLFormat_Error);
        }
        if (!config.getNodeName().equalsIgnoreCase("runtimeSettings")) {
            throw new IOException(RuntimeMessages.JSRuntimeDefinitionsContainer_WrongXMLFormat_Error);
        }
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element runtimeTypeElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (runtimeTypeElement = (Element)node).getNodeName().equalsIgnoreCase("runtimeType")) {
                JSRuntimesDefinitionsContainer.populateRuntimeType(runtimeTypeElement, container);
            }
            ++i;
        }
    }

    private static void populateRuntimeType(Element runtimeTypeElement, JSRuntimesDefinitionsContainer container) {
        String id = runtimeTypeElement.getAttribute("id");
        IJSRuntimeType runtimeType = JSRuntimeManager.getJSRuntimeType(id);
        if (runtimeType != null) {
            String defaultRuntimeInstall = runtimeTypeElement.getAttribute("defaultRuntime");
            if (!defaultRuntimeInstall.isEmpty()) {
                container.setDefaultRuntimeInstallId(id, defaultRuntimeInstall);
            }
            NodeList runtimeNodeList = runtimeTypeElement.getElementsByTagName("runtime");
            int i = 0;
            while (i < runtimeNodeList.getLength()) {
                JSRuntimesDefinitionsContainer.populateRuntimeForType(runtimeType, (Element)runtimeNodeList.item(i), container);
                ++i;
            }
        } else {
            Logger.log(4, "Runtime type with id " + id + " skipped because it is not " + "recognized by the runtime manager. " + "This will cause all children runtime installs will be skipped as well");
        }
    }

    private static void populateRuntimeForType(IJSRuntimeType runtimeType, Element runtimeElement, JSRuntimesDefinitionsContainer container) {
        String id = runtimeElement.getAttribute("id");
        if (id != null) {
            String installPath = runtimeElement.getAttribute("path");
            String name = runtimeElement.getAttribute("name");
            if (name == null) {
                Logger.log(4, "Runtime " + id + " skipped because it does not contain a name.");
                return;
            }
            if (installPath == null) {
                Logger.log(4, "Runtime " + id + " skipped because it does not contain an install path.");
                return;
            }
            JSRuntimeWorkingCopy wcRuntime = new JSRuntimeWorkingCopy(runtimeType, id);
            wcRuntime.setName(name);
            File installLocation = new File(installPath);
            wcRuntime.setInstallLocation(installLocation);
            String runtimeArgs = runtimeElement.getAttribute("runtimeArgs");
            if (runtimeArgs != null && runtimeArgs.length() > 0) {
                wcRuntime.setJSRuntimeArguments(runtimeArgs);
            }
            container.addRuntime(wcRuntime);
        } else {
            Logger.log(4, "Runtime skipped because it does not contain an id.");
        }
    }

    public void removeRuntime(IJSRuntimeInstall runtimeInstall) {
        this.fRuntimeList.remove(runtimeInstall);
        List<IJSRuntimeInstall> list = this.fRuntimeTypeToInstallMap.get(runtimeInstall.getRuntimeType());
        if (list != null) {
            list.remove(runtimeInstall);
        }
    }
}

