/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.osgi.framework.Bundle;

public class Images {
    private static final IPath ICONS_PATH = IPath.fromOSString((String)"$nl$/icons/full");

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return Images.createImageDescriptor(UnitTestPlugin.getDefault().getBundle(), path, true);
    }

    public static Image createImage(String path) {
        return Images.getImageDescriptor(path).createImage();
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        Images.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor descriptor = Images.createImageDescriptor("e" + type, relPath, true);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createImageDescriptor(String pathPrefix, String imageName, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(pathPrefix).append(imageName);
        return Images.createImageDescriptor(UnitTestPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

