/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.ws.WebServiceProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.AddAnnotationToTypeCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.AddUnimplementedMethodCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.ChangeModifierCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.ChangeReturnTypeCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.NewDefaultConstructorCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.RemoveAnnotationCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.RemoveMemberValuePairCorrectionProposal;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.RemoveMethodCorrectionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;

public class JAXWSQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 900;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        HashSet<String> handled = new HashSet<String>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String problem;
            IProblemLocation problemLocation = iProblemLocationArray[n2];
            String[] problemArguments = problemLocation.getProblemArguments();
            if (problemArguments.length >= 2 && handled.add(problem = problemArguments[1])) {
                this.process(context, problemLocation, proposals);
            }
            ++n2;
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals) throws CoreException {
        String problem = problemLocation.getProblemArguments()[1];
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_MUST_IMPLEMENT)) {
            this.addUnimplementedMethodsProposal(context, problemLocation, proposals);
        }
        if (problem.equals(JAXWSCoreMessages.WEBMETHOD_ONLY_SUPPORTED_ON_CLASSES_WITH_WEBSERVICE)) {
            this.addAnnotationToTypeProposal(context, proposals, WebService.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_NAME_ATTRIBUTE) || problem.equals(JAXWSCoreMessages.WEBSERVICE_PORTNAME_SEI) || problem.equals(JAXWSCoreMessages.WEBSERVICE_SERVICENAME_SEI) || problem.equals(JAXWSCoreMessages.WEBSERVICE_ENDPOINTINTERFACE_SEI) || problem.equals(JAXWSCoreMessages.WEBMETHOD_EXCLUDE_NOT_ALLOWED_ON_SEI)) {
            this.addRemoveMemberValuePairProposal(context, problemLocation, proposals, false);
        }
        if (problem.equals(JAXWSCoreMessages.WEBMETHOD_EXCLUDE_SPECIFIED_NO_OTHER_ATTRIBUTES_ALLOWED)) {
            this.addRemoveMemberValuePairProposal(context, problemLocation, proposals, true);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_WEBMETHODS)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, WebMethod.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_SOAPBINDING) || problem.equals(JAXWSCoreMessages.SOAPBINDING_NO_RPC_STYLE_ON_METHODS)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, SOAPBinding.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_WEBRESULT)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, WebResult.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_WEBPARAM)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, WebParam.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_NO_ONEWAY)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, Oneway.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_PUBLIC_ABSTRACT_FINAL)) {
            this.addChangeModifierProposal(context, problemLocation, proposals, 5);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_DEFAULT_PUBLIC_CONSTRUCTOR)) {
            this.addConstructorProposal(context, problemLocation, proposals, 5);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_WEBSERVICEPROVIDER_COMBINATION)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, WebServiceProvider.class);
        }
        if (problem.equals(JAXWSCoreMessages.HANDLER_CHAIN_SOAP_MESSAGE_HANDLERS)) {
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, SOAPMessageHandlers.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_OVERRIDE_FINALIZE)) {
            this.addRemoveMethodProposal(context, problemLocation, proposals);
        }
        if (problem.equals(JAXWSCoreMessages.WEBMETHOD_ONLY_ON_PUBLIC_METHODS) || problem.equals(JAXWSCoreMessages.WEBMETHOD_NO_STATIC_MODIFIER_ALLOWED) || problem.equals(JAXWSCoreMessages.WEBMETHOD_NO_FINAL_MODIFIER_ALLOWED)) {
            this.addChangeModifierProposal(context, problemLocation, proposals, 5);
            this.addRemoveAnnotationProposal(context, problemLocation, proposals, WebMethod.class);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_REDUCED_VISIBILITY)) {
            this.addChangeModifierProposal(context, problemLocation, proposals, 5);
        }
        if (problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_INCOMPATIBLE_RETURN_TYPE)) {
            this.addChangeReturnTypeProposal(context, problemLocation, proposals);
        }
    }

    private void addAnnotationToTypeProposal(IInvocationContext context, List<IJavaCompletionProposal> proposals, Class<? extends Annotation> annotationClass) {
        String displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.ADD_ANNOTATION, (Object)annotationClass.getSimpleName());
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        proposals.add(new AddAnnotationToTypeCorrectionProposal(context, annotationClass, displayString, 5, image));
    }

    private void addRemoveMethodProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals) {
        ASTNode selectedNode = problemLocation.getCoveringNode(context.getASTRoot());
        if (selectedNode.getParent() instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)selectedNode.getParent();
            ASTNode parentNode = normalAnnotation.getParent();
            if (parentNode instanceof MethodDeclaration) {
                selectedNode = ((MethodDeclaration)parentNode).getName();
            }
            if (parentNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)parentNode;
                selectedNode = ((MethodDeclaration)singleVariableDeclaration.getParent()).getName();
            }
        }
        if (selectedNode instanceof SimpleName) {
            SimpleName methodName = (SimpleName)selectedNode;
            String displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.REMOVE_METHOD, (Object)methodName.getIdentifier());
            Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            proposals.add(new RemoveMethodCorrectionProposal(context, methodName, displayString, 5, image));
        }
    }

    private void addRemoveAnnotationProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals, Class<? extends Annotation> annotation) {
        ASTNode coveringNode = problemLocation.getCoveringNode(context.getASTRoot());
        ASTNode parentNode = coveringNode.getParent();
        String displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.REMOVE_ANNOTATION, (Object)annotation.getSimpleName());
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        proposals.add(new RemoveAnnotationCorrectionProposal(context, annotation, parentNode, displayString, 5, image));
    }

    private void addRemoveMemberValuePairProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals, boolean removeAllOtherMVPs) {
        ASTNode coveringNode = problemLocation.getCoveringNode(context.getASTRoot());
        if (coveringNode.getParent() instanceof MemberValuePair) {
            MemberValuePair memberValuePair = (MemberValuePair)coveringNode.getParent();
            String displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.REMOVE_MEMBERVALUEPAIR, (Object)memberValuePair.toString());
            if (removeAllOtherMVPs) {
                displayString = JAXWSUIMessages.REMOVE_ALL_OTHER_MEMBERVALUEPAIRS;
            }
            Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            proposals.add(new RemoveMemberValuePairCorrectionProposal(context, memberValuePair, removeAllOtherMVPs, displayString, 5, image));
        }
    }

    private void addUnimplementedMethodsProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals) {
        ASTNode endpointInterfaceValue = problemLocation.getCoveringNode(context.getASTRoot());
        if (endpointInterfaceValue instanceof StringLiteral) {
            ASTNode endpointInterfaceMVP = endpointInterfaceValue.getParent();
            ASTNode webServiceAnnotation = endpointInterfaceMVP.getParent();
            ASTNode typeDeclaration = webServiceAnnotation.getParent();
            String endpointInterface = ((StringLiteral)endpointInterfaceValue).getLiteralValue();
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new AddUnimplementedMethodCorrectionProposal(context, typeDeclaration, endpointInterface, JAXWSUIMessages.ADD_UNIMPLEMENTED_METHODS, 5, image));
        }
    }

    private void addChangeModifierProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals, int relevance) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problemLocation.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            String bindingName = binding.getName();
            String displayString = "";
            int excludedModifiers = 0;
            int includedModifiers = 0;
            String problem = problemLocation.getProblemArguments()[1];
            if (problem.equals(JAXWSCoreMessages.WEBMETHOD_ONLY_ON_PUBLIC_METHODS) || problem.equals(JAXWSCoreMessages.WEBSERVICE_ENPOINTINTERFACE_REDUCED_VISIBILITY)) {
                excludedModifiers = -2;
                includedModifiers = 1;
                displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.CHANGE_METHOD_VISIBILITY, (Object)"public");
            }
            if (problem.equals(JAXWSCoreMessages.WEBMETHOD_NO_FINAL_MODIFIER_ALLOWED)) {
                excludedModifiers = 16;
                displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.REMOVE_FINAL_MODIFIER, (Object)bindingName);
            }
            if (problem.equals(JAXWSCoreMessages.WEBMETHOD_NO_STATIC_MODIFIER_ALLOWED)) {
                excludedModifiers = 8;
                displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.REMOVE_STATIC_MODIFIER, (Object)bindingName);
            }
            if (problem.equals(JAXWSCoreMessages.WEBSERVICE_PUBLIC_ABSTRACT_FINAL)) {
                excludedModifiers = 1040;
                displayString = JAXWSUIMessages.REMOVE_ILLEGAL_MODIFIER;
            }
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ChangeModifierCorrectionProposal(context, binding, includedModifiers, excludedModifiers, displayString, 5, image));
        }
    }

    private void addConstructorProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals, int relevance) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problemLocation.getCoveringNode(astRoot);
        ITypeBinding typeBinding = ((AbstractTypeDeclaration)selectedNode.getParent()).resolveBinding();
        if (typeBinding != null && typeBinding.isFromSource()) {
            String displayString = JAXWSUIMessages.bind((String)JAXWSUIMessages.CREATE_CONSTRUCTOR, (Object)typeBinding.getTypeDeclaration().getName());
            Image image = JavaElementImageProvider.getDecoratedImage((ImageDescriptor)JavaPluginImages.DESC_MISC_PUBLIC, (int)512, (Point)JavaElementImageProvider.SMALL_SIZE);
            proposals.add(new NewDefaultConstructorCorrectionProposal(context, typeBinding, displayString, 5, image));
        }
    }

    private void addChangeReturnTypeProposal(IInvocationContext context, IProblemLocation problemLocation, List<IJavaCompletionProposal> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problemLocation.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        MethodDeclaration implMethodDeclaration = (MethodDeclaration)((SimpleName)selectedNode).getParent();
        TypeDeclaration implTypeDeclaration = (TypeDeclaration)implMethodDeclaration.getParent();
        org.eclipse.jdt.core.dom.Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)implTypeDeclaration.resolveBinding().getJavaElement(), WebService.class);
        String endpointInterface = AnnotationUtils.getStringValue((org.eclipse.jdt.core.dom.Annotation)annotation, (String)"endpointInterface");
        String displayString = JAXWSUIMessages.CHANGE_METHOD_RETURN_TYPE;
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        proposals.add(new ChangeReturnTypeCorrectionProposal(context, implTypeDeclaration, implMethodDeclaration, endpointInterface, displayString, 5, image));
    }
}

