/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumValueAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class GenericJavaEnumConstant
extends AbstractJavaContextNode
implements JaxbEnumConstant {
    protected final JavaResourceEnumConstant resourceEnumConstant;
    protected String specifiedValue;

    public GenericJavaEnumConstant(JaxbEnumMapping parent, JavaResourceEnumConstant resourceEnumConstant) {
        super(parent);
        this.resourceEnumConstant = resourceEnumConstant;
        this.specifiedValue = this.getResourceEnumValue();
    }

    protected JaxbEnumMapping getEnumMapping() {
        return (JaxbEnumMapping)this.getParent();
    }

    @Override
    public JavaResourceEnumConstant getResourceEnumConstant() {
        return this.resourceEnumConstant;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedValue_(this.getResourceEnumValue());
    }

    protected XmlEnumValueAnnotation getXmlEnumValueAnnotation() {
        return (XmlEnumValueAnnotation)this.getResourceEnumConstant().getNonNullAnnotation("javax.xml.bind.annotation.XmlEnumValue");
    }

    @Override
    public String getName() {
        return this.resourceEnumConstant.getName();
    }

    @Override
    public String getValue() {
        return this.getSpecifiedValue() != null ? this.getSpecifiedValue() : this.getDefaultValue();
    }

    @Override
    public String getDefaultValue() {
        return this.getName();
    }

    @Override
    public String getSpecifiedValue() {
        return this.specifiedValue;
    }

    @Override
    public void setSpecifiedValue(String value) {
        this.getXmlEnumValueAnnotation().setValue(value);
        this.setSpecifiedValue_(value);
    }

    protected void setSpecifiedValue_(String value) {
        String old = this.specifiedValue;
        this.specifiedValue = value;
        this.firePropertyChanged("specifiedValue", old, value);
    }

    protected String getResourceEnumValue() {
        return this.getXmlEnumValueAnnotation().getValue();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        XsdTypeDefinition xsdType;
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.valueTouches(pos) && (xsdType = this.getEnumMapping().getXsdTypeDefinition()) != null && xsdType.getKind() == XsdTypeDefinition.Kind.SIMPLE) {
            XsdSimpleTypeDefinition xsdSimpleType = (XsdSimpleTypeDefinition)xsdType;
            return xsdSimpleType.getEnumValueProposals();
        }
        return EmptyIterable.instance();
    }

    protected boolean valueTouches(int pos) {
        return this.getXmlEnumValueAnnotation().valueTouches(pos);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        String value = this.getValue();
        XsdTypeDefinition xsdType = this.getEnumMapping().getXsdTypeDefinition();
        if (xsdType == null || xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            return;
        }
        if (!((XSDSimpleTypeDefinition)((XsdSimpleTypeDefinition)xsdType).getXSDComponent()).isValidLiteral(value)) {
            messages.add(this.buildValidationMessage(this.getValueTextRange(), JptJaxbCoreValidationMessages.XML_ENUM_VALUE__INVALID_LEXICAL_VALUE, value, xsdType.getName()));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getResourceEnumConstant().getTextRange();
    }

    protected TextRange getValueTextRange() {
        TextRange enumValueTextRange = this.getXmlEnumValueAnnotation().getValueTextRange();
        return enumValueTextRange != null ? enumValueTextRange : this.getValidationTextRange();
    }
}

