/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.extended;

import org.eclipse.gmf.runtime.common.ui.services.properties.extended.IExtendedPropertyDescriptor;
import org.eclipse.gmf.runtime.common.ui.services.properties.internal.l10n.CommonUIServicesPropertiesMessages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExtendedPropertyDescriptor
extends PropertyDescriptor
implements IExtendedPropertyDescriptor {
    private IPropertySource propertySource;
    private boolean dirty = false;
    private boolean readOnly = false;
    private String displayName;

    public ExtendedPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
        this.displayName = displayName;
    }

    @Override
    public IPropertySource getPropertySource() {
        return this.propertySource;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirtyFlag(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setPropertySource(IPropertySource propertySource) {
        this.propertySource = propertySource;
    }

    @Override
    public Object getBlank() {
        return CommonUIServicesPropertiesMessages.ExtendedPropertyDescriptor_blank;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean read) {
        this.readOnly = read;
    }

    @Override
    public void setPropertyValue(Object value) {
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        assert (anotherProperty != null);
        if (!(anotherProperty instanceof ExtendedPropertyDescriptor)) {
            return false;
        }
        IExtendedPropertyDescriptor xdePropertyDescriptor = (IExtendedPropertyDescriptor)anotherProperty;
        if (this.getPropertySource() == null || xdePropertyDescriptor.getPropertySource() == null) {
            return false;
        }
        IPropertySource propertySource1 = this.getPropertySource();
        IPropertySource propertySource2 = xdePropertyDescriptor.getPropertySource();
        Object value1 = propertySource1.getPropertyValue(this.getId());
        Object value2 = propertySource2.getPropertyValue(this.getId());
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 != null) {
            if (!value1.equals(value2)) {
                this.setDirtyFlag(true);
            }
        } else {
            this.setDirtyFlag(true);
        }
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Object getPropertyValue() {
        return this.getPropertySource().getPropertyValue(this.getId());
    }

    @Override
    public void resetPropertyValue() {
    }
}

