/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure.builders;

import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclVisibilityUtils;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.Messages;
import org.eclipse.dltk.tcl.structure.AbstractTclCommandModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;

public class TclProcModelBuilder
extends AbstractTclCommandModelBuilder {
    @Override
    public boolean process(TclCommand command, ITclModelBuildContext context) {
        if (command.getArguments().size() != 3) {
            this.report(context, (Node)command, Messages.TclProcProcessor_Wrong_Number_of_Arguments, ProblemSeverities.Error);
            return false;
        }
        TclArgument arg0 = (TclArgument)command.getArguments().get(0);
        String procName = TclProcModelBuilder.asSymbol(arg0);
        if (procName == null || procName.length() == 0) {
            this.report(context, (Node)command.getArguments().get(0), Messages.TclProcProcessor_Empty_Proc_Name, ProblemSeverities.Error);
            return false;
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.declarationStart = command.getStart();
        mi.nameSourceStart = arg0.getStart();
        mi.nameSourceEnd = arg0.getEnd() - 1;
        mi.name = procName;
        if (mi.name.indexOf("::") != -1) {
            String[] parts = TclParseUtil.tclSplit(mi.name);
            mi.name = parts[parts.length - 1];
        }
        mi.modifiers = TclVisibilityUtils.isPrivate(procName) ? 16 : 64;
        List<AbstractTclCommandModelBuilder.Parameter> parameters = this.parseParameters((TclArgument)command.getArguments().get(1));
        this.fillParameters(mi, parameters);
        ITclTypeHandler typeHanlder = context.get(ITclTypeResolver.class).resolveMemberType((IElementRequestor.ElementInfo)mi, command.getEnd(), procName);
        context.getRequestor().enterMethodRemoveSame(mi);
        context.addHandler(command, new MethodExit(command.getEnd()));
        context.addHandler(command, typeHanlder);
        return true;
    }

    private static class MethodExit
    implements ITclModelBuildContext.ITclModelHandler {
        final int sourceEnd;

        public MethodExit(int sourceEnd) {
            this.sourceEnd = sourceEnd;
        }

        @Override
        public void leave(ISourceElementRequestor requestor) {
            requestor.exitMethod(this.sourceEnd);
        }
    }
}

