/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;

public class TimelyCommunicationGroup
extends CommunicationGroup {
    private final boolean isSingleton;
    private final TreeMap<MessageSelector, Set<Mailbox>> mailboxQueue;
    private boolean currentlyDelivering;
    private MessageSelector currentlyDeliveredTimestamp;

    public TimelyCommunicationGroup(CommunicationTracker tracker, Node representative, int identifier, boolean isSingleton) {
        super(tracker, representative, identifier);
        this.isSingleton = isSingleton;
        this.mailboxQueue = CollectionsFactory.createTreeMap();
        this.currentlyDelivering = false;
    }

    @Override
    public void deliverMessages() {
        this.currentlyDelivering = true;
        while (!this.mailboxQueue.isEmpty()) {
            Map.Entry<MessageSelector, Set<Mailbox>> entry = this.mailboxQueue.firstEntry();
            MessageSelector timestamp = entry.getKey();
            Set<Mailbox> mailboxes = entry.getValue();
            Mailbox mailbox = mailboxes.iterator().next();
            mailboxes.remove(mailbox);
            if (mailboxes.isEmpty()) {
                this.mailboxQueue.pollFirstEntry();
            }
            assert (mailbox instanceof TimelyMailbox);
            this.currentlyDeliveredTimestamp = timestamp;
            mailbox.deliverAll(timestamp);
            this.currentlyDeliveredTimestamp = null;
        }
        this.currentlyDelivering = false;
    }

    @Override
    public boolean isEmpty() {
        return this.mailboxQueue.isEmpty();
    }

    @Override
    public void notifyHasMessage(Mailbox mailbox, MessageSelector kind) {
        if (kind instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)kind;
            Set<Mailbox> mailboxes = this.mailboxQueue.get(timestamp);
            if (mailboxes == null) {
                mailboxes = new HashSet<Mailbox>();
                this.mailboxQueue.put(timestamp, mailboxes);
            }
            mailboxes.add(mailbox);
            if (!this.isEnqueued && !this.currentlyDelivering) {
                this.tracker.activateUnenqueued(this);
            }
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + kind);
        }
    }

    @Override
    public void notifyLostAllMessages(Mailbox mailbox, MessageSelector kind) {
        if (kind instanceof Timestamp) {
            Collection mailboxes = this.mailboxQueue.get(kind);
            assert (mailboxes.contains(mailbox));
            mailboxes.remove(mailbox);
            if (mailboxes.isEmpty()) {
                this.mailboxQueue.remove(kind);
            }
            if (this.mailboxQueue.isEmpty()) {
                this.tracker.deactivate(this);
            }
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + kind);
        }
    }

    @Override
    public void addRederivable(RederivableNode node) {
        throw new UnsupportedOperationException("Differential group does not support DRed mode!");
    }

    @Override
    public void removeRederivable(RederivableNode node) {
        throw new UnsupportedOperationException("Differential group does not support DRed mode!");
    }

    @Override
    public Collection<RederivableNode> getRederivables() {
        return Collections.emptySet();
    }

    @Override
    public Map<MessageSelector, Collection<Mailbox>> getMailboxes() {
        return Collections.unmodifiableMap(this.mailboxQueue);
    }

    @Override
    public boolean isRecursive() {
        return !this.isSingleton;
    }
}

