/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editor.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.script.JSDocumentProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class ScriptDocumentProvider
extends JSDocumentProvider {
    public static final String MARK_TYPE = "org.eclipse.birt.report.debug.ui.script.scriptLineBreakpointMarker";
    public static final String SUBNAME = "sub name";
    public static final String FILENAME = "file name";
    private String id = "";
    private String fileName = "";
    private boolean isSameElement;

    public ScriptDocumentProvider(ISaveablePart part) {
        super(part);
    }

    public boolean isSameElement() {
        return this.isSameElement;
    }

    public void setSameElement(boolean isSameElement) {
        this.isSameElement = isSameElement;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new DebugResourceMarkerAnnotationModel((IResource)ResourcesPlugin.getWorkspace().getRoot());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void update(IAnnotationModel annotationModel) {
        if (!(annotationModel instanceof DebugResourceMarkerAnnotationModel)) {
            return;
        }
        DebugResourceMarkerAnnotationModel debugAnno = (DebugResourceMarkerAnnotationModel)annotationModel;
        debugAnno.disconnected();
        debugAnno.connected();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public class DebugResourceMarkerAnnotationModel
    extends ResourceMarkerAnnotationModel {
        private boolean patch;
        private Map<MarkerAnnotation, Position> markMap;
        private boolean change;

        public DebugResourceMarkerAnnotationModel(IResource resource) {
            super(resource);
            this.patch = false;
            this.markMap = new HashMap<MarkerAnnotation, Position>();
            this.change = false;
        }

        public void beforeChangeText() {
            Iterator e = this.getAnnotationIterator(true);
            while (e.hasNext()) {
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation)) continue;
                MarkerAnnotation a = (MarkerAnnotation)o;
                IMarker mark = a.getMarker();
                try {
                    if (mark == null || !ScriptDocumentProvider.this.getId().equals(mark.getAttribute(ScriptDocumentProvider.SUBNAME))) continue;
                    if (!ScriptDocumentProvider.MARK_TYPE.equals(a.getMarker().getType())) {
                    }
                }
                catch (CoreException coreException) {}
                continue;
                Position p = this.getPosition((Annotation)a);
                if (p == null || p.isDeleted()) continue;
                Position tempCopy = new Position(p.getOffset(), p.getLength());
                this.markMap.put(a, tempCopy);
            }
            this.change = true;
        }

        protected boolean isAcceptable(IMarker marker) {
            boolean bool = super.isAcceptable(marker);
            try {
                return bool && ScriptDocumentProvider.this.getId().equals(marker.getAttribute(ScriptDocumentProvider.SUBNAME)) && ScriptDocumentProvider.this.getFileName().equals(marker.getAttribute(ScriptDocumentProvider.FILENAME));
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        protected void disconnected() {
            super.disconnected();
        }

        protected void connected() {
            super.connected();
        }

        public void resetReportMarkers() {
            if (!this.change) {
                return;
            }
            for (MarkerAnnotation temp : this.markMap.keySet()) {
                this.markMap.get((Object)temp).isDeleted = false;
            }
            this.patch = true;
            this.resetMarkers();
            this.patch = false;
            ArrayList<MarkerAnnotation> markList = new ArrayList<MarkerAnnotation>();
            Iterator<MarkerAnnotation> e = this.getAnnotationIterator(true);
            while (e.hasNext()) {
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation)) continue;
                MarkerAnnotation a = (MarkerAnnotation)o;
                try {
                    if (a.getMarker() == null || !ScriptDocumentProvider.this.getId().equals(a.getMarker().getAttribute(ScriptDocumentProvider.SUBNAME))) continue;
                    if (!ScriptDocumentProvider.MARK_TYPE.equals(a.getMarker().getType())) {
                    }
                }
                catch (CoreException coreException) {}
                continue;
                IMarker p = this.findTrueMark(a);
                if (p != null || !ScriptDocumentProvider.this.isSameElement()) continue;
                markList.add(a);
            }
            for (MarkerAnnotation temp : this.markMap.keySet()) {
                this.removeAnnotation((Annotation)temp, true);
                try {
                    this.addAnnotation((Annotation)temp, this.markMap.get(temp), true);
                }
                catch (BadLocationException badLocationException) {}
            }
            this.removeAnnotations(markList, true, true);
            this.markMap.clear();
            markList.clear();
            this.change = false;
        }

        protected Position createPositionFromMarker(IMarker marker) {
            Position p = super.createPositionFromMarker(marker);
            if (p == null && this.patch) {
                p = new Position(0, 0);
                p.isDeleted = true;
            }
            return p;
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            IMarker marker;
            if (annotation instanceof MarkerAnnotation && (marker = ((MarkerAnnotation)annotation).getMarker()) != null) {
                try {
                    if (!ScriptDocumentProvider.this.getId().equals(marker.getAttribute(ScriptDocumentProvider.SUBNAME))) {
                        return;
                    }
                    if (!ScriptDocumentProvider.MARK_TYPE.equals(marker.getType())) {
                        return;
                    }
                }
                catch (CoreException coreException) {}
            }
            super.addAnnotation(annotation, position, fireModelChanged);
        }

        private IMarker findTrueMark(MarkerAnnotation a) {
            for (MarkerAnnotation temp : this.markMap.keySet()) {
                if (!a.getMarker().equals((Object)temp.getMarker())) continue;
                return temp.getMarker();
            }
            return null;
        }
    }
}

