/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public final class RandomAccessFileVol
extends Volume {
    public static final VolumeFactory FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            return new RandomAccessFileVol(new File(file), readOnly, fileLockWait, initSize);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return new File(file).exists();
        }

        @Override
        public boolean handlesReadonly() {
            return true;
        }
    };
    protected final File file;
    protected final RandomAccessFile raf;
    protected final FileLock fileLock;
    protected final boolean readOnly;

    public RandomAccessFileVol(File file, boolean readOnly, long fileLockWait, long initSize) {
        this.file = file;
        this.readOnly = readOnly;
        try {
            this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
            this.fileLock = Volume.lockFile(file, this.raf.getChannel(), readOnly, fileLockWait);
            if (initSize != 0L && !readOnly) {
                long oldLen = this.raf.length();
                if (initSize > this.raf.length()) {
                    this.raf.setLength(initSize);
                    this.clear(oldLen, initSize);
                }
            }
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void ensureAvailable(long offset) {
        try {
            if (this.raf.length() < offset) {
                this.raf.setLength(offset);
            }
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void truncate(long size) {
        try {
            this.raf.setLength(size);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void putLong(long offset, long value) {
        try {
            this.raf.seek(offset);
            this.raf.writeLong(value);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void putInt(long offset, int value) {
        try {
            this.raf.seek(offset);
            this.raf.writeInt(value);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void putByte(long offset, byte value) {
        try {
            this.raf.seek(offset);
            this.raf.writeByte(value);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void putData(long offset, byte[] src, int srcPos, int srcSize) {
        try {
            this.raf.seek(offset);
            this.raf.write(src, srcPos, srcSize);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void putData(long offset, ByteBuffer buf) {
        byte[] bb = buf.array();
        int pos = buf.position();
        int size = buf.limit() - pos;
        if (bb == null) {
            bb = new byte[size];
            buf.get(bb);
            pos = 0;
        }
        this.putData(offset, bb, pos, size);
    }

    @Override
    public synchronized long getLong(long offset) {
        try {
            this.raf.seek(offset);
            return this.raf.readLong();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized int getInt(long offset) {
        try {
            this.raf.seek(offset);
            return this.raf.readInt();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized byte getByte(long offset) {
        try {
            this.raf.seek(offset);
            return this.raf.readByte();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized DataInput2 getDataInput(long offset, int size) {
        try {
            this.raf.seek(offset);
            byte[] b = new byte[size];
            this.raf.readFully(b);
            return new DataInput2.ByteArray(b);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void getData(long offset, byte[] bytes, int bytesPos, int size) {
        try {
            this.raf.seek(offset);
            this.raf.readFully(bytes, bytesPos, size);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
            this.raf.close();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void sync() {
        try {
            this.raf.getFD().sync();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public int sliceSize() {
        return 0;
    }

    @Override
    public boolean isSliced() {
        return false;
    }

    @Override
    public synchronized long length() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public synchronized boolean getFileLocked() {
        return this.fileLock != null && this.fileLock.isValid();
    }

    @Override
    public synchronized void clear(long startOffset, long endOffset) {
        try {
            RandomAccessFileVol.clearRAF(this.raf, startOffset, endOffset);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    protected static void clearRAF(RandomAccessFile raf, long startOffset, long endOffset) throws IOException {
        raf.seek(startOffset);
        while (startOffset < endOffset) {
            long remaining = Math.min((long)CLEAR.length, endOffset - startOffset);
            raf.write(CLEAR, 0, (int)remaining);
            startOffset += (long)CLEAR.length;
        }
    }

    @Override
    public synchronized void putUnsignedShort(long offset, int value) {
        try {
            this.raf.seek(offset);
            this.raf.write(value >> 8);
            this.raf.write(value);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized int getUnsignedShort(long offset) {
        try {
            this.raf.seek(offset);
            return this.raf.readUnsignedByte() << 8 | this.raf.readUnsignedByte();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized long getSixLong(long offset) {
        try {
            this.raf.seek(offset);
            return (long)this.raf.readUnsignedByte() << 40 | (long)this.raf.readUnsignedByte() << 32 | (long)this.raf.readUnsignedByte() << 24 | (long)(this.raf.readUnsignedByte() << 16) | (long)(this.raf.readUnsignedByte() << 8) | (long)this.raf.readUnsignedByte();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void putSixLong(long pos, long value) {
        if (value >>> 48 != 0L) {
            throw new DBException.DataCorruption("six long out of range");
        }
        try {
            this.raf.seek(pos);
            this.raf.write((int)(value >>> 40));
            this.raf.write((int)(value >>> 32));
            this.raf.write((int)(value >>> 24));
            this.raf.write((int)(value >>> 16));
            this.raf.write((int)(value >>> 8));
            this.raf.write((int)value);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized int putPackedLong(long pos, long value) {
        try {
            this.raf.seek(pos);
            int ret = 1;
            int shift = 63 - Long.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                ++ret;
                this.raf.write((int)(value >>> shift & 0x7FL));
                shift -= 7;
            }
            this.raf.write((int)(value & 0x7FL | 0x80L));
            return ret;
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized long getPackedLong(long pos) {
        try {
            byte v;
            this.raf.seek(pos);
            long ret = 0L;
            long pos2 = 0L;
            do {
                ++pos2;
                v = this.raf.readByte();
                ret = ret << 7 | (long)(v & 0x7F);
            } while ((v & 0x80) == 0);
            return pos2 << 60 | ret;
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

