/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class CanonicalizeGroupedTailStepTransform
extends BaseTransform {
    private CanonicalizeGroupedTailStepTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)n;
                String ptxt = pt.getPathText();
                String afterTail = CanonicalizeGroupedTailStepTransform.rewriteGroupedTail(ptxt);
                String rew = CanonicalizeGroupedTailStepTransform.rewriteFuseSplitMiddle(afterTail);
                if (!rew.equals(ptxt)) {
                    IrPathTriple np = new IrPathTriple(pt.getSubject(), rew, pt.getObject(), pt.isNewScope(), pt.getPathVars());
                    m = np;
                }
            } else if (!(n instanceof IrSubSelect)) {
                m = BaseTransform.rewriteContainers(n, child -> CanonicalizeGroupedTailStepTransform.apply(child, r));
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    static String rewriteFuseSplitMiddle(String path) {
        if (path == null) {
            return null;
        }
        String s = path.trim();
        if (!s.startsWith("((")) {
            return s;
        }
        int first = s.indexOf(")/(");
        if (first <= 0) {
            return s;
        }
        String afterFirst = s.substring(first + 3);
        int second = afterFirst.indexOf(")/(");
        if (second <= 0) {
            return s;
        }
        String left = s.substring(2, first);
        String mid = afterFirst.substring(0, second);
        String rightWithParens = afterFirst.substring(second + 2);
        if (rightWithParens.length() < 3 || rightWithParens.charAt(0) != '(' || rightWithParens.charAt(rightWithParens.length() - 1) != ')') {
            return s;
        }
        String right = rightWithParens.substring(1, rightWithParens.length() - 1);
        if (mid.indexOf(63) >= 0 || mid.indexOf(42) >= 0 || mid.indexOf(43) >= 0) {
            return s;
        }
        return "((" + left + ")/(" + mid + "/(" + right + ")))";
    }

    static String rewriteGroupedTail(String path) {
        if (path == null) {
            return null;
        }
        String s = path.trim();
        int sep = s.indexOf(")/(");
        if (sep <= 0 || s.charAt(0) != '(' || s.charAt(s.length() - 1) != ')') {
            return s;
        }
        String left = s.substring(1, sep);
        String rightWithParens = s.substring(sep + 2);
        if (rightWithParens.length() < 3 || rightWithParens.charAt(0) != '(' || rightWithParens.charAt(rightWithParens.length() - 1) != ')') {
            return s;
        }
        String right = rightWithParens.substring(1, rightWithParens.length() - 1);
        int lastSlash = right.lastIndexOf(47);
        if (lastSlash < 0) {
            return s;
        }
        String base = right.substring(0, lastSlash);
        String tail = right.substring(lastSlash + 1);
        if (tail.isEmpty() || tail.contains("|") || tail.contains("(") || tail.contains(")") || tail.endsWith("?") || tail.endsWith("*") || tail.endsWith("+")) {
            return s;
        }
        return "((" + left + ")/(" + base + "))/" + tail;
    }
}

