/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchIndex;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchSpatialSupport;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.search.SearchHit;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

@Deprecated(since="5.3.0", forRemoval=true)
public class ElasticsearchDocument
implements SearchDocument {
    private final String id;
    private final String type;
    @Deprecated
    private long version;
    private final long seqNo;
    private final long primaryTerm;
    private final String index;
    private final Map<String, Object> fields;
    private final Function<? super String, ? extends SpatialContext> geoContextMapper;

    @Deprecated
    public ElasticsearchDocument(SearchHit hit) {
        this(hit, null);
    }

    public ElasticsearchDocument(SearchHit hit, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this(hit.getId(), hit.getType(), hit.getIndex(), hit.getSeqNo(), hit.getPrimaryTerm(), hit.getSourceAsMap(), geoContextMapper);
    }

    public ElasticsearchDocument(String id, String type, String index, String resourceId, String context, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this(id, type, index, -2L, 0L, new HashMap<String, Object>(), geoContextMapper);
        this.fields.put("uri", resourceId);
        if (context != null) {
            this.fields.put("context", context);
        }
    }

    @Deprecated
    public ElasticsearchDocument(String id, String type, String index, long version, Map<String, Object> fields, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this(id, type, index, -2L, 0L, new HashMap<String, Object>(), geoContextMapper);
        this.version = version;
    }

    public ElasticsearchDocument(String id, String type, String index, long seqNo, long primaryTerm, Map<String, Object> fields, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this.id = id;
        this.type = type;
        this.version = -3L;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.index = index;
        this.fields = fields;
        this.geoContextMapper = geoContextMapper;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    @Deprecated
    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getIndex() {
        return this.index;
    }

    public Map<String, Object> getSource() {
        return this.fields;
    }

    @Override
    public String getResource() {
        return (String)this.fields.get("uri");
    }

    @Override
    public String getContext() {
        return (String)this.fields.get("context");
    }

    public Set<String> getPropertyNames() {
        Set<String> propertyFields = ElasticsearchIndex.getPropertyFields(this.fields.keySet());
        HashSet<String> propertyNames = new HashSet<String>(propertyFields.size() + 1);
        for (String f : propertyFields) {
            propertyNames.add(ElasticsearchIndex.toPropertyName(f));
        }
        return propertyNames;
    }

    @Override
    public void addProperty(String name) {
        String fieldName = ElasticsearchIndex.toPropertyFieldName(name);
        if (this.fields.containsKey(fieldName)) {
            throw new IllegalStateException("Property already added: " + name);
        }
        this.fields.put(fieldName, null);
        if (!this.fields.containsKey("text")) {
            this.fields.put("text", null);
        }
    }

    @Override
    public void addProperty(String name, String text) {
        String fieldName = ElasticsearchIndex.toPropertyFieldName(name);
        ElasticsearchDocument.addField(fieldName, text, this.fields);
        ElasticsearchDocument.addField("text", text, this.fields);
    }

    @Override
    public void addGeoProperty(String name, String text) {
        String fieldName = ElasticsearchIndex.toPropertyFieldName(name);
        ElasticsearchDocument.addField(fieldName, text, this.fields);
        try {
            Shape shape = ((SpatialContext)this.geoContextMapper.apply((Object)name)).readShapeFromWkt(text);
            if (shape instanceof Point) {
                Point p = (Point)shape;
                this.fields.put(ElasticsearchIndex.toGeoPointFieldName(name), new GeoPoint(p.getY(), p.getX()).getGeohash());
            } else {
                this.fields.put(ElasticsearchIndex.toGeoShapeFieldName(name), ElasticsearchSpatialSupport.getSpatialSupport().toGeoJSON(shape));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasProperty(String name, String value) {
        String fieldName = ElasticsearchIndex.toPropertyFieldName(name);
        List<String> fieldValues = ElasticsearchDocument.asStringList(this.fields.get(fieldName));
        if (fieldValues != null) {
            for (String fieldValue : fieldValues) {
                if (!value.equals(fieldValue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getProperty(String name) {
        String fieldName = ElasticsearchIndex.toPropertyFieldName(name);
        return ElasticsearchDocument.asStringList(this.fields.get(fieldName));
    }

    private static void addField(String name, String value, Map<String, Object> document) {
        Object newValue;
        Object oldValue = document.get(name);
        if (oldValue != null) {
            List<String> newList = ElasticsearchDocument.makeModifiable(ElasticsearchDocument.asStringList(oldValue));
            newList.add(value);
            newValue = newList;
        } else {
            newValue = value;
        }
        document.put(name, newValue);
    }

    private static List<String> makeModifiable(List<String> l) {
        List<String> modList;
        if (!(l instanceof ArrayList)) {
            modList = new ArrayList<String>(l.size() + 1);
            modList.addAll(l);
        } else {
            modList = l;
        }
        return modList;
    }

    private static List<String> asStringList(Object value) {
        List<String> l = value == null ? null : (value instanceof List ? (List<String>)value : Collections.singletonList((String)value));
        return l;
    }
}

