/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.AbstractTriple;

public class SimpleTriple
extends AbstractTriple {
    private final Resource subject;
    private final IRI predicate;
    private final Value object;

    protected SimpleTriple(Resource subject, IRI predicate, Value object) {
        this.subject = Objects.requireNonNull(subject, "subject must not be null");
        this.predicate = Objects.requireNonNull(predicate, "predicate must not be null");
        this.object = Objects.requireNonNull(object, "object must not be null");
    }

    public Resource getSubject() {
        return this.subject;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public Value getObject() {
        return this.object;
    }

    public String stringValue() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<<");
        sb.append(this.getSubject());
        sb.append(" ");
        sb.append(this.getPredicate());
        sb.append(" ");
        sb.append(this.getObject());
        sb.append(">>");
        return sb.toString();
    }

    public String toString() {
        return this.stringValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Triple) {
            Triple that = (Triple)o;
            return Objects.equals(this.subject, that.getSubject()) && Objects.equals(this.predicate, that.getPredicate()) && Objects.equals(this.object, that.getObject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.predicate, this.object);
    }
}

