/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

class LmdbStatementIterator
extends AbstractCloseableIteration<Statement> {
    private final RecordIterator recordIt;
    private final ValueStore valueStore;
    private Statement nextElement;

    public LmdbStatementIterator(RecordIterator recordIt, ValueStore valueStore) {
        this.recordIt = recordIt;
        this.valueStore = valueStore;
    }

    public Statement getNextElement() throws SailException {
        try {
            long[] quad = this.recordIt.next();
            if (quad == null) {
                return null;
            }
            long subjID = quad[0];
            Resource subj = (Resource)this.valueStore.getLazyValue(subjID);
            long predID = quad[1];
            IRI pred = (IRI)this.valueStore.getLazyValue(predID);
            long objID = quad[2];
            LmdbValue obj = this.valueStore.getLazyValue(objID);
            Resource context = null;
            long contextID = quad[3];
            if (contextID != 0L) {
                context = (Resource)this.valueStore.getLazyValue(contextID);
            }
            return this.valueStore.createStatement(subj, pred, obj, context);
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    protected void handleClose() throws SailException {
        this.recordIt.close();
    }

    private SailException causeIOException(IOException e) {
        return new SailException((Throwable)e);
    }

    public final boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        return this.lookAhead() != null;
    }

    public final Statement next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        Statement result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private Statement lookAhead() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                this.close();
            }
        }
        return this.nextElement;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

