/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.lmdb.TripleStore;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LmdbEvaluationStatistics
extends EvaluationStatistics {
    private static final Logger log = LoggerFactory.getLogger(LmdbEvaluationStatistics.class);
    private final ValueStore valueStore;
    private final TripleStore tripleStore;

    public LmdbEvaluationStatistics(ValueStore valueStore, TripleStore tripleStore) {
        this.valueStore = valueStore;
        this.tripleStore = tripleStore;
    }

    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new LmdbCardinalityCalculator();
    }

    private double cardinality(Resource subj, IRI pred, Value obj, Resource context) throws IOException {
        long subjID = -1L;
        if (subj != null && (subjID = this.valueStore.getId((Value)subj)) == -1L) {
            return 0.0;
        }
        long predID = -1L;
        if (pred != null && (predID = this.valueStore.getId((Value)pred)) == -1L) {
            return 0.0;
        }
        long objID = -1L;
        if (obj != null && (objID = this.valueStore.getId(obj)) == -1L) {
            return 0.0;
        }
        long contextID = -1L;
        if (context != null && (contextID = this.valueStore.getId((Value)context)) == -1L) {
            return 0.0;
        }
        return this.tripleStore.cardinality(subjID, predID, objID, contextID);
    }

    protected class LmdbCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected LmdbCardinalityCalculator() {
        }

        protected double getCardinality(StatementPattern sp) {
            try {
                Value pred;
                Value subj = this.getConstantValue(sp.getSubjectVar());
                if (!(subj instanceof Resource)) {
                    subj = null;
                }
                if (!((pred = this.getConstantValue(sp.getPredicateVar())) instanceof IRI)) {
                    pred = null;
                }
                Value obj = this.getConstantValue(sp.getObjectVar());
                Value context = this.getConstantValue(sp.getContextVar());
                if (!(context instanceof Resource)) {
                    context = null;
                }
                return LmdbEvaluationStatistics.this.cardinality((Resource)subj, (IRI)pred, obj, (Resource)context);
            }
            catch (IOException e) {
                log.error("Failed to estimate statement pattern cardinality, falling back to generic implementation", (Throwable)e);
                return super.getCardinality(sp);
            }
        }

        protected Value getConstantValue(Var var) {
            return var != null ? var.getValue() : null;
        }
    }
}

