/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGroupByElem;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOrderSpec;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrProjectionItem;

public class IrSelect
extends IrNode {
    private final List<IrProjectionItem> projection = new ArrayList<IrProjectionItem>();
    private final List<IrGroupByElem> groupBy = new ArrayList<IrGroupByElem>();
    private final List<String> having = new ArrayList<String>();
    private final List<IrOrderSpec> orderBy = new ArrayList<IrOrderSpec>();
    private boolean distinct;
    private boolean reduced;
    private IrBGP where;
    private long limit = -1L;
    private long offset = -1L;

    public IrSelect(boolean newScope) {
        super(newScope);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setReduced(boolean reduced) {
        this.reduced = reduced;
    }

    public List<IrProjectionItem> getProjection() {
        return this.projection;
    }

    public IrBGP getWhere() {
        return this.where;
    }

    public void setWhere(IrBGP bgp) {
        this.where = bgp;
    }

    public List<IrGroupByElem> getGroupBy() {
        return this.groupBy;
    }

    public List<String> getHaving() {
        return this.having;
    }

    public List<IrOrderSpec> getOrderBy() {
        return this.orderBy;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrNode t;
        IrBGP newWhere = this.where;
        if (newWhere != null && (t = (IrNode)op.apply(newWhere)) instanceof IrBGP) {
            newWhere = (IrBGP)t;
        }
        IrSelect copy = new IrSelect(this.isNewScope());
        copy.setDistinct(this.distinct);
        copy.setReduced(this.reduced);
        copy.getProjection().addAll(this.projection);
        copy.setWhere(newWhere);
        copy.getGroupBy().addAll(this.groupBy);
        copy.getHaving().addAll(this.having);
        copy.getOrderBy().addAll(this.orderBy);
        copy.setLimit(this.limit);
        copy.setOffset(this.offset);
        return copy;
    }

    @Override
    public void print(IrPrinter p) {
        StringBuilder hdr = new StringBuilder(64);
        hdr.append("SELECT ");
        if (this.distinct) {
            hdr.append("DISTINCT ");
        } else if (this.reduced) {
            hdr.append("REDUCED ");
        }
        if (this.projection.isEmpty()) {
            hdr.append("*");
        } else {
            for (int i = 0; i < this.projection.size(); ++i) {
                IrProjectionItem it = this.projection.get(i);
                if (it.getExprText() == null) {
                    hdr.append('?').append(it.getVarName());
                } else {
                    hdr.append('(').append(it.getExprText()).append(" AS ?").append(it.getVarName()).append(')');
                }
                if (i + 1 >= this.projection.size()) continue;
                hdr.append(' ');
            }
        }
        p.startLine();
        p.append(hdr.toString());
        p.append(" WHERE ");
        if (this.where != null) {
            this.where.print(p);
        } else {
            p.openBlock();
            p.closeBlock();
        }
        if (!this.groupBy.isEmpty()) {
            StringBuilder gb = new StringBuilder("GROUP BY");
            for (IrGroupByElem g : this.groupBy) {
                if (g.getExprText() == null) {
                    gb.append(' ').append('?').append(g.getVarName());
                    continue;
                }
                gb.append(" (").append(g.getExprText()).append(" AS ?").append(g.getVarName()).append(")");
            }
            p.line(gb.toString());
        }
        if (!this.having.isEmpty()) {
            StringBuilder hv = new StringBuilder("HAVING");
            for (String cond : this.having) {
                Object t;
                Object object = t = cond == null ? "" : cond.trim();
                if (!(((String)t).isEmpty() || ((String)t).startsWith("(") && ((String)t).endsWith(")"))) {
                    t = "(" + (String)t + ")";
                }
                hv.append(' ').append((String)t);
            }
            p.line(hv.toString());
        }
        if (!this.orderBy.isEmpty()) {
            StringBuilder ob = new StringBuilder("ORDER BY");
            for (IrOrderSpec o : this.orderBy) {
                if (o.isAscending()) {
                    ob.append(' ').append(o.getExprText());
                    continue;
                }
                ob.append(" DESC(").append(o.getExprText()).append(')');
            }
            p.line(ob.toString());
        }
        if (this.limit >= 0L) {
            p.line("LIMIT " + this.limit);
        }
        if (this.offset >= 0L) {
            p.line("OFFSET " + this.offset);
        }
    }

    @Override
    public Set<Var> getVars() {
        if (this.where != null) {
            return this.where.getVars();
        }
        return Collections.emptySet();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isReduced() {
        return this.reduced;
    }
}

