/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ndjsonld;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.document.JsonDocument;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.jsonld.JSONLDParser;

public class NDJSONLDParser
extends JSONLDParser {
    public NDJSONLDParser() {
    }

    public NDJSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NDJSONLD;
    }

    @Override
    protected Document getDocument(InputStream in, Reader reader) throws JsonLdError, IOException {
        if (in != null && reader == null) {
            reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        }
        ArrayList<JsonValue> arrayOfJSONLD = new ArrayList<JsonValue>();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                JsonDocument jsonDocument;
                Optional jsonContent;
                if (line.isEmpty() || !(jsonContent = (jsonDocument = JsonDocument.of((InputStream)new ByteArrayInputStream(line.getBytes(StandardCharsets.UTF_8)))).getJsonContent()).isPresent()) continue;
                JsonStructure jsonStructure = (JsonStructure)jsonContent.get();
                if (jsonStructure.getValueType() == JsonValue.ValueType.ARRAY) {
                    arrayOfJSONLD.addAll((Collection<JsonValue>)jsonStructure.asJsonArray());
                }
                arrayOfJSONLD.add((JsonValue)jsonContent.get());
            }
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder(arrayOfJSONLD);
            JsonArray jsonArray = arrayBuilder.build();
            JsonDocument jsonDocument = JsonDocument.of((JsonStructure)jsonArray);
            return jsonDocument;
        }
    }

    @Override
    public void parse(InputStream in, String baseURI) throws RDFParseException, RDFHandlerException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be 'null'");
        }
        this.parse(new InputStreamReader((InputStream)new BOMInputStream(in, false), StandardCharsets.UTF_8), baseURI);
    }
}

