/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakObjectRegistry<K, E extends K>
extends AbstractSet<E> {
    private static final Logger logger = LoggerFactory.getLogger(WeakObjectRegistry.class);
    private final Map<E, WeakReference<E>>[] objectMap;
    private final AdderBasedReadWriteLock[] locks;

    public WeakObjectRegistry() {
        int concurrency = Runtime.getRuntime().availableProcessors() * 2;
        this.objectMap = new WeakHashMap[concurrency];
        for (int i = 0; i < this.objectMap.length; ++i) {
            this.objectMap[i] = new WeakHashMap<E, WeakReference<E>>();
        }
        this.locks = new AdderBasedReadWriteLock[this.objectMap.length];
        for (int index = 0; index < this.locks.length; ++index) {
            this.locks[index] = new AdderBasedReadWriteLock();
        }
    }

    public WeakObjectRegistry(int cacheSize, Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(K key) {
        if (key == null) {
            return null;
        }
        int index = this.getIndex(key);
        boolean readLock = this.locks[index].readLock();
        try {
            Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
            WeakReference<E> weakRef = weakReferenceMap.get(key);
            if (weakRef != null) {
                Object t = weakRef.get();
                return (E)t;
            }
            E e = null;
            return e;
        }
        finally {
            this.locks[index].unlockReader(readLock);
        }
    }

    private int getIndex(Object key) {
        int i = Math.abs(key.hashCode());
        return i % this.objectMap.length;
    }

    public AutoCloseableIterator<E> closeableIterator() {
        return new AutoCloseableIterator<E>(this.objectMap, this.locks);
    }

    @Override
    public Iterator<E> iterator() {
        logger.warn("This method is not thread safe! Use closeableIterator() instead.");
        return new AutoCloseableIterator<E>(this.objectMap, null);
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<E, WeakReference<E>> weakReferenceMap : this.objectMap) {
            size += weakReferenceMap.size();
        }
        return size;
    }

    @Override
    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E object) {
        int index = this.getIndex(object);
        boolean writeLock = this.locks[index].writeLock();
        try {
            Object e;
            Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
            WeakReference<E> ref = new WeakReference<E>(object);
            ref = weakReferenceMap.put(object, ref);
            if (ref != null && (e = ref.get()) != null) {
                weakReferenceMap.put(e, ref);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.locks[index].unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getOrAdd(K key, Supplier<E> supplier) {
        int index = this.getIndex(key);
        Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
        boolean readLock = this.locks[index].readLock();
        try {
            Object e;
            WeakReference<E> ref = weakReferenceMap.get(key);
            if (ref != null && (e = ref.get()) != null) {
                Object t = e;
                return (E)t;
            }
        }
        finally {
            this.locks[index].unlockReader(readLock);
        }
        boolean writeLock = this.locks[index].writeLock();
        try {
            Object e;
            Object object = supplier.get();
            WeakReference<E> ref = weakReferenceMap.put(object, new WeakReference<E>(object));
            if (ref != null && (e = ref.get()) != null) {
                weakReferenceMap.put(e, ref);
                object = e;
            }
            assert (object != null);
            E e2 = object;
            return e2;
        }
        finally {
            this.locks[index].unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        int index = this.getIndex(object);
        boolean writeLock = this.locks[index].writeLock();
        try {
            Map<E, WeakReference<E>> weakReferenceMap = this.objectMap[index];
            WeakReference<E> ref = weakReferenceMap.remove(object);
            boolean bl = ref != null && ref.get() != null;
            return bl;
        }
        finally {
            this.locks[index].unlockWriter(writeLock);
        }
    }

    @Override
    public void clear() {
        for (int index = 0; index < this.objectMap.length; ++index) {
            boolean writeLock = this.locks[index].writeLock();
            try {
                this.objectMap[index].clear();
                continue;
            }
            finally {
                this.locks[index].unlockWriter(writeLock);
            }
        }
    }

    private static class AdderBasedReadWriteLock {
        private volatile boolean writeLocked;
        private static final VarHandle WRITE_LOCKED;
        private final LongAdder readersLocked = new LongAdder();
        private final LongAdder readersUnlocked = new LongAdder();

        private AdderBasedReadWriteLock() {
        }

        public boolean readLock() {
            block0: while (true) {
                this.readersLocked.increment();
                if (!WRITE_LOCKED.getAcquire(this)) {
                    return true;
                }
                this.readersUnlocked.increment();
                while (true) {
                    if (!WRITE_LOCKED.getAcquire(this)) continue block0;
                    Thread.onSpinWait();
                }
                break;
            }
        }

        public void unlockReader(boolean locked) {
            if (!locked) {
                throw new IllegalMonitorStateException();
            }
            this.readersUnlocked.increment();
        }

        public boolean writeLock() {
            boolean writeLocked;
            while (!(writeLocked = WRITE_LOCKED.compareAndSet(this, false, true))) {
            }
            long lockedSum;
            long unlockedSum;
            while ((unlockedSum = this.readersUnlocked.sum()) != (lockedSum = this.readersLocked.sum())) {
                Thread.onSpinWait();
            }
            return writeLocked;
        }

        public void unlockWriter(boolean writeLocked) {
            if (writeLocked) {
                VarHandle.fullFence();
                WRITE_LOCKED.setRelease(this, false);
            }
        }

        static {
            try {
                WRITE_LOCKED = MethodHandles.lookup().in(AdderBasedReadWriteLock.class).findVarHandle(AdderBasedReadWriteLock.class, "writeLocked", Boolean.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }

    public static class AutoCloseableIterator<E>
    implements Iterator<E>,
    AutoCloseable {
        private final Iterator<Map<E, WeakReference<E>>> iterator;
        private final AdderBasedReadWriteLock[] locks;
        Iterator<E> currentIterator;
        boolean[] readLocks;
        boolean init = false;

        public AutoCloseableIterator(Map<E, WeakReference<E>>[] objectMap, AdderBasedReadWriteLock[] locks) {
            this.iterator = Arrays.asList(objectMap).iterator();
            this.locks = locks;
        }

        public void init() {
            if (!this.init) {
                this.init = true;
                if (this.locks != null) {
                    this.readLocks = new boolean[this.locks.length];
                    for (int index = 0; index < this.locks.length; ++index) {
                        this.readLocks[index] = this.locks[index].readLock();
                    }
                }
                this.currentIterator = this.iterator.next().keySet().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.init();
            if (this.currentIterator == null) {
                return false;
            }
            while (this.currentIterator != null) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
                if (!this.iterator.hasNext()) continue;
                this.currentIterator = this.iterator.next().keySet().iterator();
            }
            return false;
        }

        @Override
        public E next() {
            this.init();
            return this.currentIterator.next();
        }

        @Override
        public void close() {
            if (this.init && this.locks != null) {
                for (int index = 0; index < this.locks.length; ++index) {
                    if (!this.readLocks[index]) continue;
                    this.locks[index].unlockReader(this.readLocks[index]);
                    this.readLocks[index] = false;
                }
            }
        }
    }
}

